/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import java.math.BigInteger;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AddressBarContributionItem;
import org.eclipse.jface.action.Action;

public class JumpToAddressAction
extends Action {
    DisassemblyPart fDisassemblyPart = null;

    public JumpToAddressAction(DisassemblyPart disassemblyPart) {
        this.fDisassemblyPart = disassemblyPart;
    }

    public void run() {
        AddressBarContributionItem addressBar = this.fDisassemblyPart.getAddressBar();
        if (addressBar != null && addressBar.isEnabled() && this.fDisassemblyPart.isSuspended()) {
            String locationTxt = addressBar.getText();
            if (locationTxt == null || locationTxt.trim().length() == 0) {
                return;
            }
            if ((locationTxt = locationTxt.trim()).equals(DisassemblyMessages.Disassembly_GotoLocation_initial_text)) {
                this.fDisassemblyPart.gotoActiveFrameByUser();
                return;
            }
            BigInteger address = this.fDisassemblyPart.eval(locationTxt, false);
            if (address.compareTo(BigInteger.ZERO) < 0) {
                addressBar.setWarningIconVisible(true);
            } else {
                this.fDisassemblyPart.gotoLocationByUser(address, locationTxt);
                addressBar.setWarningIconVisible(false);
            }
        }
    }

    protected void activateDisassemblyContext() {
        this.fDisassemblyPart.activateDisassemblyContext();
    }

    protected void deactivateDisassemblyContext() {
        this.fDisassemblyPart.deactivateDisassemblyContext();
    }
}

