/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class MouseMoveSelectionEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    @Override
    public int getEvent() {
        return 4;
    }

    @Override
    public int getStateMask() {
        return 524288;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        IPlotArea plotArea = baseChart.getPlotArea();
        if (!plotArea.isBuffered() && baseChart.getChartSettings().isBufferSelection()) {
            ISeries[] series;
            baseChart.suspendUpdate(true);
            Image image = new Image((Device)Display.getDefault(), baseChart.getPlotArea().getImageData());
            ISeriesSet set = baseChart.getSeriesSet();
            ISeries[] iSeriesArray = series = set.getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries serie = iSeriesArray[n2];
                serie.setVisibleBuffered(serie.isVisible());
                baseChart.hideSeries(serie.getId());
                ++n2;
            }
            plotArea.setBackgroundImage(image);
            plotArea.getControl().setData("BUFFERED_BACKGROUND_IMAGE", (Object)image);
            plotArea.setBuffered(true);
            baseChart.suspendUpdate(false);
            baseChart.redraw();
        }
        baseChart.getUserSelection().setStopCoordinate(event.x, event.y);
        baseChart.increaseRedrawCounter();
        if (baseChart.isRedraw()) {
            baseChart.redraw();
            baseChart.resetRedrawCounter();
        }
    }
}

