/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.LegendElement;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.TaskAttachmentPage;
import org.eclipse.ui.IEditorInput;

public abstract class AbstractRepositoryConnectorUi {
    private static final String LABEL_TASK_DEFAULT = Messages.AbstractRepositoryConnectorUi_Task;
    private final boolean customNotificationHandling = false;
    private final AbstractRepositoryConnector connector;

    public AbstractRepositoryConnectorUi(AbstractRepositoryConnector connector) {
        this.connector = connector;
    }

    public AbstractRepositoryConnectorUi() {
        this(null);
    }

    public abstract @NonNull String getConnectorKind();

    public abstract @NonNull ITaskRepositoryPage getSettingsPage(@Nullable TaskRepository var1);

    public abstract @NonNull IWizard getQueryWizard(@NonNull TaskRepository var1, @Nullable IRepositoryQuery var2);

    public abstract @NonNull IWizard getNewTaskWizard(@NonNull TaskRepository var1, @Nullable ITaskMapping var2);

    public @Nullable IWizard getNewSubTaskWizard(@NonNull TaskRepository taskRepository, @NonNull ITask parentTask) {
        return null;
    }

    public @NonNull String getTaskEditorId(@NonNull ITask repositoryTask) {
        return "org.eclipse.mylyn.tasks.ui.editors.task";
    }

    public @NonNull IEditorInput getTaskEditorInput(@NonNull TaskRepository repository, @NonNull ITask task) {
        return new TaskEditorInput(repository, task);
    }

    public abstract boolean hasSearchPage();

    @Deprecated
    public @NonNull List<ITask> getLegendItems() {
        return Collections.emptyList();
    }

    public @NonNull List<LegendElement> getLegendElements() {
        return Collections.emptyList();
    }

    public @NonNull String getTaskKindLabel(@Nullable ITask task) {
        return LABEL_TASK_DEFAULT;
    }

    public @Nullable ImageDescriptor getImageDescriptor(@NonNull IRepositoryElement element) {
        if (element instanceof RepositoryQuery) {
            return ((RepositoryQuery)element).getAutoUpdate() ? TasksUiImages.QUERY : TasksUiImages.QUERY_OFFLINE;
        }
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getRepositoryUrl());
            if (repository != null && this.connector != null && this.connector.isOwnedByUser(repository, task)) {
                return TasksUiImages.TASK_OWNED;
            }
            return TasksUiImages.TASK;
        }
        return null;
    }

    public @Nullable ImageDescriptor getTaskKindOverlay(@NonNull ITask task) {
        return null;
    }

    public @NonNull ImageDescriptor getTaskPriorityOverlay(@NonNull ITask task) {
        return TasksUiInternal.getPriorityImage(task);
    }

    @Deprecated
    public @Nullable IWizard getAddExistingTaskWizard(@Nullable TaskRepository repository) {
        return null;
    }

    public @Nullable ITaskSearchPage getSearchPage(@NonNull TaskRepository repository, @Nullable IStructuredSelection selection) {
        return null;
    }

    public @Nullable String getAccountCreationUrl(@NonNull TaskRepository taskRepository) {
        return null;
    }

    public @Nullable String getAccountManagementUrl(@NonNull TaskRepository taskRepository) {
        return null;
    }

    public @Nullable String getTaskHistoryUrl(@NonNull TaskRepository taskRepository, @NonNull ITask task) {
        return null;
    }

    public @Nullable String getReplyText(@NonNull TaskRepository taskRepository, @NonNull ITask task, @Nullable ITaskComment taskComment, boolean includeTask) {
        if (taskComment == null) {
            return Messages.AbstractRepositoryConnectorUi_InReplyToDescription;
        }
        if (includeTask) {
            return MessageFormat.format(Messages.AbstractRepositoryConnectorUi_InReplyToTaskAndComment, task.getTaskKey(), taskComment.getNumber());
        }
        return MessageFormat.format(Messages.AbstractRepositoryConnectorUi_InReplyToComment, taskComment.getNumber());
    }

    @Deprecated
    public @Nullable IHyperlink[] findHyperlinks(@NonNull TaskRepository repository, @NonNull String text, int index, int textOffset) {
        return null;
    }

    public boolean hasCustomNotifications() {
        return false;
    }

    public boolean hasStrictSubtaskHierarchy() {
        return false;
    }

    public @NonNull IWizardPage getTaskAttachmentPage(@NonNull TaskAttachmentModel model) {
        return new TaskAttachmentPage(model);
    }

    public @Nullable IHyperlink[] findHyperlinks(@NonNull TaskRepository repository, @Nullable ITask task, @NonNull String text, int index, int textOffset) {
        return this.findHyperlinks(repository, text, index, textOffset);
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }
}

