/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.changes;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.DocumentAdapter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.UndoTextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;

public class UndoCTextFileChange
extends UndoTextFileChange {
    UndoEdit mUndoEdit = null;

    public UndoCTextFileChange(String name, IFile file, UndoEdit undo, ContentStamp stamp, int saveMode) {
        super(name, file, undo, stamp, saveMode);
        this.mUndoEdit = undo;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Object obj;
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (!((obj = this.getModifiedElement()) instanceof IFile)) {
            throw new IllegalArgumentException();
        }
        IFile file = (IFile)obj;
        ICElement element = CoreModel.getDefault().create(file);
        if (!(element instanceof TranslationUnit)) {
            return super.perform(pm);
        }
        TranslationUnit tu = (TranslationUnit)element;
        IWorkingCopy wc = tu.getWorkingCopy(pm, DocumentAdapter.FACTORY);
        IBuffer buffer = wc.getBuffer();
        assert (buffer instanceof DocumentAdapter);
        if (buffer instanceof DocumentAdapter) {
            IDocument document = ((DocumentAdapter)buffer).getDocument();
            try {
                UndoEdit redo = this.mUndoEdit.apply(document, 1);
                wc.commit(false, pm);
                UndoCTextFileChange undoCTextFileChange = new UndoCTextFileChange(this.getName(), file, redo, null, this.getSaveMode());
                return undoCTextFileChange;
            }
            catch (MalformedTreeException e) {
                CUIPlugin.log(e);
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
            finally {
                wc.destroy();
            }
        }
        return null;
    }
}

