/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.AccessorDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.FieldDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterContext;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterLabelProvider;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterNameGenerator;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class GenerateGettersAndSettersInputPage
extends UserInputWizardPage
implements IEclipsePreferences.IPreferenceChangeListener {
    private GetterSetterContext context;
    private ContainerCheckedTreeViewer variableSelectionView;
    private GetterSetterLabelProvider labelProvider;

    public GenerateGettersAndSettersInputPage(GetterSetterContext context) {
        super(Messages.GenerateGettersAndSettersInputPage_Name);
        this.context = context;
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.ui");
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.GenerateGettersAndSettersInputPage_Name);
        this.setMessage(Messages.GenerateGettersAndSettersInputPage_Header);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.createTree(comp);
        GridData gd = new GridData(1808);
        this.variableSelectionView.getTree().setLayoutData((Object)gd);
        Composite buttonContainer = this.createButtonComposite(comp);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonContainer.setLayoutData((Object)gd);
        final Button definitionSeparate = new Button(comp, 32);
        definitionSeparate.setText(Messages.GenerateGettersAndSettersInputPage_SeparateDefinition);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.heightHint = 40;
        definitionSeparate.setLayoutData((Object)gd);
        definitionSeparate.setSelection(this.context.isDefinitionSeparate());
        definitionSeparate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateGettersAndSettersInputPage.this.context.setDefinitionSeparate(definitionSeparate.getSelection());
            }
        });
        Link link = new Link(comp, 64);
        link.setText(Messages.GenerateGettersAndSettersInputPage_LinkDescription);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.eclipse.cdt.ui.preferences.NameStylePreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)GenerateGettersAndSettersInputPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
            }
        });
        link.setToolTipText(Messages.GenerateGettersAndSettersInputPage_LinkTooltip);
        gd = new GridData(4, 0x1000000, true, false);
        gd.grabExcessHorizontalSpace = true;
        link.setLayoutData((Object)gd);
        this.setControl((Control)comp);
    }

    private Composite createButtonComposite(Composite comp) {
        Composite btComp = new Composite(comp, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 4;
        btComp.setLayout((Layout)layout);
        Button selectAll = new Button(btComp, 8);
        selectAll.setText(Messages.GenerateGettersAndSettersInputPage_SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items;
                Object[] objectArray = items = GenerateGettersAndSettersInputPage.this.context.getElements(null);
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object treeItem = objectArray[n2];
                    GenerateGettersAndSettersInputPage.this.variableSelectionView.setChecked(treeItem, true);
                    ++n2;
                }
                GenerateGettersAndSettersInputPage.this.updateSelectedFunctions();
            }
        });
        Button deselectAll = new Button(btComp, 8);
        deselectAll.setText(Messages.GenerateGettersAndSettersInputPage_DeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = GenerateGettersAndSettersInputPage.this.context.getElements(null);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object treeItem = objectArray[n2];
                    GenerateGettersAndSettersInputPage.this.variableSelectionView.setChecked(treeItem, false);
                    ++n2;
                }
                GenerateGettersAndSettersInputPage.this.updateSelectedFunctions();
            }
        });
        Button selectGetter = new Button(btComp, 8);
        selectGetter.setText(Messages.GenerateGettersAndSettersInputPage_SelectGetters);
        selectGetter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateGettersAndSettersInputPage.this.selectAccessors(AccessorDescriptor.AccessorKind.GETTER);
            }
        });
        Button selectSetter = new Button(btComp, 8);
        selectSetter.setText(Messages.GenerateGettersAndSettersInputPage_SelectSetters);
        selectSetter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GenerateGettersAndSettersInputPage.this.selectAccessors(AccessorDescriptor.AccessorKind.SETTER);
            }
        });
        return btComp;
    }

    private void selectAccessors(AccessorDescriptor.AccessorKind kind) {
        Object[] objectArray = this.context.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object treeItem = objectArray[n2];
            if (treeItem instanceof FieldDescriptor) {
                Object[] children;
                FieldDescriptor field = (FieldDescriptor)treeItem;
                Object[] objectArray2 = children = this.context.getChildren(field);
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    AccessorDescriptor accessor;
                    Object child = objectArray2[n4];
                    if (child instanceof AccessorDescriptor && (accessor = (AccessorDescriptor)child).getKind() == kind) {
                        this.variableSelectionView.setChecked((Object)accessor, true);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.updateSelectedFunctions();
    }

    private void createTree(Composite comp) {
        this.variableSelectionView = new ContainerCheckedTreeViewer(comp, 2048);
        this.labelProvider = new GetterSetterLabelProvider();
        this.variableSelectionView.setContentProvider((IContentProvider)this.context);
        this.variableSelectionView.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.variableSelectionView.setAutoExpandLevel(3);
        this.variableSelectionView.setInput((Object)this.context);
        if (this.context.selectedName != null) {
            String rawSignature = this.context.selectedName.getRawSignature();
            Object[] objectArray = this.variableSelectionView.getVisibleExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof FieldDescriptor && obj.toString().contains(rawSignature)) {
                    this.variableSelectionView.setSubtreeChecked(obj, true);
                }
                ++n2;
            }
        }
        this.updateSelectedFunctions();
        this.variableSelectionView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GenerateGettersAndSettersInputPage.this.updateSelectedFunctions();
            }
        });
    }

    private void updateSelectedFunctions() {
        this.context.selectedAccessors.clear();
        Object[] objectArray = this.variableSelectionView.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof AccessorDescriptor) {
                this.context.selectedAccessors.add((AccessorDescriptor)element);
            }
            ++n2;
        }
        this.setPageComplete(!this.context.selectedAccessors.isEmpty());
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.variableSelectionView.getTree().isDisposed()) {
            return;
        }
        if (GetterSetterNameGenerator.getGenerateGetterSettersPreferenceKeys().contains(event.getKey())) {
            this.context.recreateFieldDescriptors();
            this.variableSelectionView.refresh();
            this.variableSelectionView.setInput((Object)this.context);
            for (Object e : this.context.selectedAccessors) {
                this.variableSelectionView.setChecked(e, true);
            }
        }
    }

    public void dispose() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.ui");
        node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }
}

