/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.refactoring;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.DocumentAdapter;
import org.eclipse.cdt.internal.ui.refactoring.changes.UndoCTextFileChange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class CTextFileChange
extends TextFileChange {
    private static final String TEXT_TYPE = "c2";
    private ITranslationUnit fTranslationUnit;
    private IWorkingCopy fWorkingCopy;
    private int fAcquireCount;

    public CTextFileChange(String name, IFile file) {
        super(name, file);
        ICElement element = CoreModel.getDefault().create(file);
        if (element instanceof ITranslationUnit) {
            this.fTranslationUnit = (ITranslationUnit)element;
            this.setTextType(TEXT_TYPE);
        }
    }

    public CTextFileChange(String name, ITranslationUnit tu) {
        super(name, tu.getFile());
        this.fTranslationUnit = tu;
        if (tu instanceof IWorkingCopy) {
            this.fWorkingCopy = (IWorkingCopy)tu;
        }
        this.setTextType(TEXT_TYPE);
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        IDocument doc = super.acquireDocument(pm);
        if (++this.fAcquireCount == 1 && this.fWorkingCopy == null && this.fTranslationUnit instanceof TranslationUnit) {
            this.fWorkingCopy = ((TranslationUnit)this.fTranslationUnit).getWorkingCopy(null, DocumentAdapter.FACTORY);
            if (!this.fTranslationUnit.isOpen()) {
                this.fTranslationUnit.open(null);
            }
        }
        return doc;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.fWorkingCopy == null) {
            super.commit(document, pm);
        } else if (this.needsSaving()) {
            this.fWorkingCopy.commit(false, pm);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        super.releaseDocument(document, pm);
        if (--this.fAcquireCount == 0 && this.fWorkingCopy != null && this.fWorkingCopy != this.fTranslationUnit) {
            this.fWorkingCopy.destroy();
            this.fWorkingCopy = null;
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        return new UndoCTextFileChange(this.getName(), this.getFile(), edit, stampToRestore, this.getSaveMode());
    }
}

