/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree.uiwidgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UIBooleanWidget
extends InputUIElement {
    protected Button button;
    protected Label label;
    protected UIComposite uiComposite;
    private boolean booleanValue;

    public UIBooleanWidget(UIAttributes uiAttributes, boolean defaultValue) {
        super(uiAttributes);
        this.booleanValue = defaultValue;
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put((String)this.uiAttributes.get("id"), Boolean.toString(this.booleanValue));
        return values;
    }

    @Override
    public void setValues(Map<String, String> valueMap) {
        this.booleanValue = Boolean.parseBoolean(valueMap.get(this.uiAttributes.get("id")));
    }

    @Override
    public void createWidgets(UIComposite uiComposite) {
        GridData gridData = null;
        this.uiComposite = uiComposite;
        this.label = new Label((Composite)uiComposite, 16384);
        this.label.setText((String)this.uiAttributes.get("label"));
        if (this.uiAttributes.get("description") != null) {
            String tipText = (String)this.uiAttributes.get("description");
            tipText = tipText.replaceAll("\\\\r\\\\n", "\r\n");
            this.label.setToolTipText(tipText);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Composite booleanContainer = new Composite((Composite)uiComposite, 0);
        GridData gridcData = new GridData(768);
        booleanContainer.setLayout((Layout)new GridLayout());
        booleanContainer.setLayoutData((Object)gridcData);
        this.button = new Button(booleanContainer, 32);
        this.button.setData(".uid", this.uiAttributes.get("id"));
        this.button.setSelection(this.booleanValue);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIBooleanWidget.this.booleanValue = UIBooleanWidget.this.button.getSelection();
            }
        });
    }

    @Override
    public boolean isValid() {
        boolean retVal = true;
        String mandatory = (String)this.uiAttributes.get("mandatory");
        if (!this.booleanValue && Boolean.parseBoolean(mandatory)) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void disposeWidget() {
        this.label.dispose();
        this.button.dispose();
    }
}

