/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.p2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class P2Fetcher {
    public static List<UnitNode> fetchAvailableUnits(String repositoryLocation) {
        ArrayList<UnitNode> units = new ArrayList<UnitNode>();
        IQueryResult result = null;
        try {
            URI uri;
            try {
                uri = new URI(repositoryLocation);
            }
            catch (URISyntaxException e) {
                return units;
            }
            BundleContext context = FrameworkUtil.getBundle(P2Fetcher.class).getBundleContext();
            ServiceReference sr = context.getServiceReference(IProvisioningAgentProvider.class);
            IProvisioningAgentProvider agentProvider = null;
            agentProvider = (IProvisioningAgentProvider)context.getService(sr);
            IProvisioningAgent agent = null;
            try {
                agent = agentProvider.createAgent(null);
            }
            catch (ProvisionException e) {
                e.printStackTrace();
            }
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IMetadataRepository repository = manager.loadRepository(uri, null);
            result = repository.query(QueryUtil.createLatestIUQuery(), null);
            for (IInstallableUnit unit : result) {
                UnitNode modelUnit = new UnitNode();
                modelUnit.setId(unit.getId());
                modelUnit.setVersion(unit.getVersion().getOriginal());
                IQueryResult versions = repository.query(QueryUtil.createIUQuery((String)unit.getId()), null);
                for (IInstallableUnit version : versions) {
                    modelUnit.getAvailableVersions().add(version.getVersion().getOriginal());
                }
                units.add(modelUnit);
            }
            return units;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

