/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.wizards;

import aQute.bnd.build.Workspace;
import aQute.bnd.service.RepositoryPlugin;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.bndtools.api.ILogger;
import org.bndtools.api.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryTreeContentProvider;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryTreeLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

class LocalRepositorySelectionPage
extends WizardPage {
    private static final ILogger logger = Logger.getLogger(LocalRepositorySelectionPage.class);
    public static final String PROP_SELECTED_REPO = "selectedRepository";
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport((Object)this);
    private RepositoryPlugin selectedRepository = null;
    private Workspace workspace;

    LocalRepositorySelectionPage(Workspace workspace, String pageName) {
        this(workspace, pageName, null);
    }

    LocalRepositorySelectionPage(Workspace workspace, String pageName, RepositoryPlugin selectedRepository) {
        super(pageName);
        this.workspace = workspace;
        this.selectedRepository = selectedRepository;
    }

    public void createControl(Composite parent) {
        this.setTitle("Select Local Repository");
        this.setMessage("Bundle will be imported into the selected repository.");
        Table table = new Table(parent, 67588);
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new RepositoryTreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeLabelProvider(false));
        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof RepositoryPlugin && ((RepositoryPlugin)element).canWrite();
            }
        }});
        try {
            viewer.setInput((Object)this.workspace);
            if (this.selectedRepository != null) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedRepository));
            }
            this.validate(this.workspace);
        }
        catch (Exception e) {
            logger.logError("Error querying local repositories", (Throwable)e);
            this.setErrorMessage("Error querying local repositories, see log for details.");
        }
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.setSelectedRepository((RepositoryPlugin)selection.getFirstElement());
        });
        viewer.addOpenListener(evt -> {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.setSelectedRepository((RepositoryPlugin)selection.getFirstElement());
            IWizardPage nextPage = this.getNextPage();
            if (nextPage != null) {
                this.getContainer().showPage(nextPage);
            }
        });
        this.setControl((Control)table);
    }

    private void validate(Workspace workspace) {
        String error = "No writeable local repositories are configured.";
        List plugins = workspace.getPlugins(RepositoryPlugin.class);
        if (plugins != null) {
            for (RepositoryPlugin plugin : plugins) {
                if (!plugin.canWrite()) continue;
                error = null;
                break;
            }
        }
        this.setErrorMessage(error);
    }

    public boolean isPageComplete() {
        return this.selectedRepository != null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(propertyName, listener);
    }

    private void setSelectedRepository(RepositoryPlugin item) {
        RepositoryPlugin old = this.selectedRepository;
        this.selectedRepository = item;
        this.propSupport.firePropertyChange(PROP_SELECTED_REPO, old, this.selectedRepository);
        this.getContainer().updateButtons();
    }

    public RepositoryPlugin getSelectedRepository() {
        return this.selectedRepository;
    }
}

