/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.log;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.scout.sdk.core.log.ISdkConsoleSpi;
import org.eclipse.scout.sdk.core.log.LogMessage;

public final class SdkConsole {
    private static volatile ISdkConsoleSpi spi = new P_DefaultConsoleSpi();

    private SdkConsole() {
    }

    public static synchronized ISdkConsoleSpi getConsoleSpi() {
        return spi;
    }

    public static synchronized void setConsoleSpi(ISdkConsoleSpi newSpi) {
        if (newSpi == null) {
            newSpi = new P_DefaultConsoleSpi();
        }
        spi = newSpi;
    }

    public static synchronized void clear() {
        spi.clear();
    }

    static synchronized void println(LogMessage message) {
        spi.println(message);
    }

    static synchronized boolean isEnabled(Level level) {
        return level != null && spi.isEnabled(level);
    }

    private static final class P_DefaultConsoleSpi
    implements ISdkConsoleSpi {
        private static final PrintStream OUT = System.out;
        private static final PrintStream ERR = System.err;

        private P_DefaultConsoleSpi() {
        }

        @Override
        public void clear() {
            char[] line = new char[50];
            Arrays.fill(line, '_');
            OUT.println(line);
        }

        @Override
        public void println(LogMessage msg) {
            PrintStream out = Level.SEVERE.equals(msg.severity()) ? ERR : OUT;
            out.println(msg.all());
        }
    }
}

