/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.log;

import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.scout.sdk.core.log.FormattingTuple;
import org.eclipse.scout.sdk.core.log.LogMessage;
import org.eclipse.scout.sdk.core.log.MessageFormatter;
import org.eclipse.scout.sdk.core.log.SdkConsole;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public final class SdkLog {
    public static final String LOG_LEVEL_PROPERTY_NAME = "org.eclipse.scout.sdk.propLogLevel";
    public static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
    static Clock clock = Clock.systemDefaultZone();
    private static volatile Level curLevel = SdkLog.getInitialLogLevel();

    private SdkLog() {
    }

    public static void log(Level level, CharSequence msg, Object ... args) {
        if (level == null) {
            level = DEFAULT_LOG_LEVEL;
        }
        if (!SdkConsole.isEnabled(level)) {
            return;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(msg, args);
        LogMessage message = new LogMessage(level, SdkLog.defaultPrefixFor(level), tuple.message(), tuple.throwables());
        SdkConsole.println(message);
    }

    static String defaultPrefixFor(Level level) {
        int levelColWidth = 8;
        String levelName = level.getName();
        CharSequence spaces = Strings.repeat(" ", levelColWidth - levelName.length());
        return SdkLog.logTime() + " [" + levelName + ']' + spaces;
    }

    static String logTime() {
        LocalDateTime now = LocalDateTime.now(clock);
        return now.format(TIME_FORMATTER);
    }

    public static void debug(Object ... args) {
        SdkLog.debug(null, args);
    }

    public static void debug(CharSequence message, Object ... args) {
        SdkLog.log(Level.FINE, message, args);
    }

    public static void info(Object ... args) {
        SdkLog.info(null, args);
    }

    public static void info(CharSequence message, Object ... args) {
        SdkLog.log(Level.INFO, message, args);
    }

    public static void warning(Object ... args) {
        SdkLog.warning(null, args);
    }

    public static void warning(CharSequence message, Object ... args) {
        SdkLog.log(Level.WARNING, message, args);
    }

    public static void error(Object ... args) {
        SdkLog.error("", args);
    }

    public static void error(CharSequence message, Object ... args) {
        SdkLog.log(Level.SEVERE, message, args);
    }

    public static Level getLogLevel() {
        return curLevel;
    }

    public static void setLogLevel(Level newLevel) {
        curLevel = Ensure.notNull(newLevel);
    }

    public static void setLogLevel(String newLevelName) {
        curLevel = SdkLog.parseLevel(newLevelName);
    }

    public static void setInitialLogLevel() {
        SdkLog.setLogLevel(SdkLog.getInitialLogLevel());
    }

    public static boolean isLevelEnabled(Level level) {
        return SdkConsole.isEnabled(level);
    }

    public static boolean isDebugEnabled() {
        return SdkLog.isLevelEnabled(Level.FINE);
    }

    public static boolean isInfoEnabled() {
        return SdkLog.isLevelEnabled(Level.INFO);
    }

    public static boolean isWarningEnabled() {
        return SdkLog.isLevelEnabled(Level.WARNING);
    }

    public static boolean isErrorEnabled() {
        return SdkLog.isLevelEnabled(Level.SEVERE);
    }

    public static <T> T onDebug(T t) {
        return SdkLog.onLevel(t, Level.FINE);
    }

    public static <T> T onTrace(T t) {
        return SdkLog.onLevel(t, Level.FINER);
    }

    public static <T> T onLevel(T t, Level level) {
        if (SdkLog.isLevelEnabled(level)) {
            return t;
        }
        return null;
    }

    static Level parseLevel(String lvl) {
        if (Strings.isBlank(lvl)) {
            return DEFAULT_LOG_LEVEL;
        }
        try {
            Level parsedLevel = Level.parse(lvl);
            if (parsedLevel != null) {
                return parsedLevel;
            }
        }
        catch (Exception e) {
            String msg = "Unable to parse log level '" + lvl + "'. Fallback to default: '" + DEFAULT_LOG_LEVEL.getName() + "'.";
            SdkConsole.println(new LogMessage(Level.SEVERE, SdkLog.defaultPrefixFor(Level.SEVERE), msg, Collections.singletonList(e)));
        }
        return DEFAULT_LOG_LEVEL;
    }

    static Level getInitialLogLevel() {
        String lvl = System.getProperty(LOG_LEVEL_PROPERTY_NAME);
        if (Strings.isBlank(lvl)) {
            return DEFAULT_LOG_LEVEL;
        }
        return SdkLog.parseLevel(lvl);
    }
}

