/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util.visitor;

import java.util.function.Function;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.visitor.DefaultDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.IDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.TreeVisitResult;

public class DepthFirstVisitorTypeAdapter<T, U extends T>
implements IDepthFirstVisitor<T> {
    private final Class<U> m_type;
    private final IDepthFirstVisitor<U> m_visitor;

    public static <S> IDepthFirstVisitor<S> functionToPreOrderVisitor(final Function<S, TreeVisitResult> visitor) {
        Ensure.notNull(visitor);
        return new DefaultDepthFirstVisitor<S>(){

            @Override
            public TreeVisitResult preVisit(S element, int level, int index) {
                return (TreeVisitResult)((Object)visitor.apply(element));
            }
        };
    }

    public DepthFirstVisitorTypeAdapter(Function<U, TreeVisitResult> visitor, Class<U> type) {
        this(DepthFirstVisitorTypeAdapter.functionToPreOrderVisitor(visitor), type);
    }

    public DepthFirstVisitorTypeAdapter(IDepthFirstVisitor<U> visitor, Class<U> type) {
        this.m_type = Ensure.notNull(type);
        this.m_visitor = Ensure.notNull(visitor);
    }

    @Override
    public TreeVisitResult preVisit(T element, int level, int index) {
        return this.delegateToFunctionIfTypeMatches(element, e -> this.innerVisitor().preVisit(e, level, index), TreeVisitResult.CONTINUE);
    }

    @Override
    public boolean postVisit(T element, int level, int index) {
        return this.delegateToFunctionIfTypeMatches(element, e -> this.innerVisitor().postVisit(e, level, index), true);
    }

    protected <S> S delegateToFunctionIfTypeMatches(T element, Function<U, S> function, S resultOnTypeMismatch) {
        if (this.type().isInstance(element)) {
            return function.apply(element);
        }
        return resultOnTypeMismatch;
    }

    public Class<U> type() {
        return this.m_type;
    }

    public IDepthFirstVisitor<U> innerVisitor() {
        return this.m_visitor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for type '" + this.type().getName() + "'.";
    }
}

