/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.eval.EvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.actions.ExpressionInputDialog;
import org.eclipse.jdt.internal.debug.ui.actions.StringValueInputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class JavaObjectValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        try {
            IJavaVariable javaVariable = (IJavaVariable)variable;
            String signature = javaVariable.getSignature();
            if ("Ljava/lang/String;".equals(signature)) {
                StringValueInputDialog dialog = new StringValueInputDialog(shell, javaVariable);
                if (dialog.open() == 0) {
                    String result = dialog.getResult();
                    if (dialog.isUseLiteralValue()) {
                        variable.setValue(result);
                    } else {
                        this.setValue(variable, result);
                    }
                }
            } else {
                ExpressionInputDialog dialog = new ExpressionInputDialog(shell, javaVariable);
                if (dialog.open() == 0) {
                    String result = dialog.getResult();
                    this.setValue(variable, result);
                }
            }
        }
        catch (DebugException e) {
            this.handleException(e);
        }
        return true;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        block3: {
            IJavaVariable javaVariable = (IJavaVariable)variable;
            String signature = null;
            signature = javaVariable.getSignature();
            if (!"Ljava/lang/String;".equals(signature)) break block3;
            return false;
        }
        try {
            this.setValue(variable, expression);
        }
        catch (DebugException e) {
            this.handleException(e);
        }
        return true;
    }

    protected void setValue(final IVariable variable, final String expression) {
        UIJob job = new UIJob("Setting Variable Value"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (expression == null || expression.length() == 0) {
                        variable.setValue(expression);
                    } else {
                        IValue newValue = JavaObjectValueEditor.this.evaluate(expression, variable);
                        if (newValue != null) {
                            variable.setValue(newValue);
                        } else {
                            variable.setValue(expression);
                        }
                    }
                }
                catch (DebugException de) {
                    JavaObjectValueEditor.this.handleException(de);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void handleException(DebugException e) {
        Throwable cause = e.getStatus().getException();
        if (cause instanceof InvalidTypeException) {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 120, cause.getMessage(), null);
            JDIDebugUIPlugin.statusDialog(ActionMessages.JavaObjectValueEditor_3, (IStatus)status);
        } else {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IValue evaluate(String stringValue, final IVariable variable) throws DebugException {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        IJavaStackFrame frame = (IJavaStackFrame)adaptable.getAdapter(IJavaStackFrame.class);
        if (frame != null) {
            final IJavaThread thread = (IJavaThread)frame.getThread();
            IJavaProject project = this.getProject(frame);
            if (project != null) {
                final IEvaluationResult[] results = new IEvaluationResult[1];
                IAstEvaluationEngine engine = JDIDebugPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)thread.getDebugTarget());
                IEvaluationListener listener = new IEvaluationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void evaluationComplete(IEvaluationResult result) {
                        EvaluationResult convertedResult = JavaObjectValueEditor.this.convert((EvaluationResult)result, variable, thread);
                        JavaObjectValueEditor javaObjectValueEditor = JavaObjectValueEditor.this;
                        synchronized (javaObjectValueEditor) {
                            results[0] = convertedResult;
                            JavaObjectValueEditor.this.notifyAll();
                        }
                    }
                };
                JavaObjectValueEditor javaObjectValueEditor = this;
                synchronized (javaObjectValueEditor) {
                    block13: {
                        engine.evaluate(stringValue, frame, listener, 128, false);
                        try {
                            if (results[0] == null) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException e) {
                            if (results[0] != null) break block13;
                            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.JavaObjectValueEditor_0, (Throwable)e);
                            throw new DebugException((IStatus)status);
                        }
                    }
                }
                IEvaluationResult result = results[0];
                if (result == null) {
                    return null;
                }
                if (result.hasErrors()) {
                    DebugException exception = result.getException();
                    StringBuilder buffer = new StringBuilder();
                    if (exception == null) {
                        String[] messages = result.getErrorMessages();
                        int i = 0;
                        while (i < messages.length) {
                            buffer.append(messages[i]).append("\n ");
                            ++i;
                        }
                    } else {
                        buffer.append(EvaluateAction.getExceptionMessage(exception));
                    }
                    Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, buffer.toString(), null);
                    throw new DebugException((IStatus)status);
                }
                return result.getValue();
            }
        }
        return null;
    }

    private EvaluationResult convert(EvaluationResult evaluationResult, IVariable variable, IJavaThread thread) {
        block32: {
            if (evaluationResult.hasErrors()) {
                return evaluationResult;
            }
            IJavaValue value = evaluationResult.getValue();
            if (!(value instanceof IJavaPrimitiveValue)) break block32;
            IJavaPrimitiveValue primValue = (IJavaPrimitiveValue)value;
            if (!(variable instanceof IJavaVariable)) break block32;
            try {
                IJavaType type = ((IJavaVariable)variable).getJavaType();
                if (!(type instanceof IJavaClassType)) break block32;
                IJavaClassType classType = (IJavaClassType)type;
                IJavaDebugTarget javaDebug = (IJavaDebugTarget)thread.getDebugTarget().getAdapter(IJavaDebugTarget.class);
                switch (classType.getName()) {
                    case "java.math.BigInteger": 
                    case "java.lang.Long": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getLongValue()), classType, thread);
                        break;
                    }
                    case "java.lang.Integer": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getIntValue()), classType, thread);
                        break;
                    }
                    case "java.lang.Short": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getShortValue()), classType, thread);
                        break;
                    }
                    case "java.lang.Byte": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getByteValue()), classType, thread);
                        break;
                    }
                    case "java.math.BigDecimal": 
                    case "java.lang.Double": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getDoubleValue()), classType, thread);
                        break;
                    }
                    case "java.lang.Float": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getFloatValue()), classType, thread);
                        break;
                    }
                    case "java.lang.Boolean": {
                        this.updateEvaluation(evaluationResult, javaDebug.newValue(primValue.getBooleanValue()), classType, thread);
                    }
                }
            }
            catch (DebugException e) {
                evaluationResult.setException(e);
            }
        }
        return evaluationResult;
    }

    private void updateEvaluation(EvaluationResult evaluationResult, IJavaValue newValue, IJavaClassType instanceType, IJavaThread thread) throws DebugException {
        String signature = String.format("(%s)%s", newValue.getSignature(), instanceType.getSignature());
        this.updateEvaluation(evaluationResult, newValue, instanceType, "valueOf", signature, thread);
    }

    private void updateEvaluation(EvaluationResult evaluationResult, IJavaValue newValue, IJavaClassType instanceType, String methodName, String signature, IJavaThread thread) throws DebugException {
        evaluationResult.setValue(instanceType.sendMessage(methodName, signature, new IJavaValue[]{newValue}, thread));
    }

    protected String getExceptionMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            Throwable throwable = ce.getStatus().getException();
            if (throwable instanceof InvocationException) {
                return this.getInvocationExceptionMessage((InvocationException)throwable);
            }
            if (throwable instanceof CoreException) {
                return this.getExceptionMessage(throwable);
            }
            return ce.getStatus().getMessage();
        }
        String message = NLS.bind((String)ActionMessages.Evaluate_error_message_direct_exception, (Object[])new Object[]{exception.getClass()});
        if (exception.getMessage() != null) {
            message = NLS.bind((String)ActionMessages.Evaluate_error_message_exception_pattern, (Object[])new Object[]{message, exception.getMessage()});
        }
        return message;
    }

    protected String getInvocationExceptionMessage(InvocationException exception) {
        InvocationException ie = exception;
        ObjectReference ref = ie.exception();
        return NLS.bind((String)ActionMessages.Evaluate_error_message_wrapped_exception, (Object[])new Object[]{ref.referenceType().name()});
    }

    private IJavaProject getProject(IJavaStackFrame javaStackFrame) {
        return JavaDebugUtils.resolveJavaProject((IJavaStackFrame)javaStackFrame);
    }
}

