/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.generator.type;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.typescript.builder.ITypeScriptSourceBuilder;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.AbstractNodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.ICompositeTypeGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.util.Ensure;

public class CompositeTypeGenerator<TYPE extends ICompositeTypeGenerator<TYPE>>
extends AbstractNodeElementGenerator<TYPE>
implements ICompositeTypeGenerator<TYPE> {
    private IDataType.DataTypeFlavor m_flavor = IDataType.DataTypeFlavor.Single;
    private int m_arrayDimension = 1;
    private final Collection<ISourceGenerator<? super ITypeScriptSourceBuilder<?>>> m_types = new LinkedHashSet();

    protected CompositeTypeGenerator() {
    }

    public static ICompositeTypeGenerator<?> create() {
        return new CompositeTypeGenerator();
    }

    @Override
    protected void build(ITypeScriptSourceBuilder<?> builder) {
        super.build(builder);
        IDataType.DataTypeFlavor flavor = this.flavor().orElseThrow(() -> Ensure.newFail((CharSequence)"Composite must have a flavor.", (Object[])new Object[0]));
        String delimiter = switch (flavor) {
            case IDataType.DataTypeFlavor.Union -> " | ";
            case IDataType.DataTypeFlavor.Intersection -> " & ";
            default -> null;
        };
        String suffix = flavor == IDataType.DataTypeFlavor.Array ? "[]".repeat(this.arrayDimension()) : null;
        builder.append(this.types().map(t -> t.generalize((ISourceBuilder)builder)), null, delimiter, suffix);
    }

    @Override
    public Optional<IDataType.DataTypeFlavor> flavor() {
        return Optional.ofNullable(this.m_flavor);
    }

    @Override
    public TYPE withFlavor(IDataType.DataTypeFlavor flavor) {
        this.m_flavor = flavor;
        return (TYPE)((ICompositeTypeGenerator)this.thisInstance());
    }

    @Override
    public int arrayDimension() {
        return this.m_arrayDimension;
    }

    @Override
    public TYPE withArrayDimension(int dimension) {
        this.m_arrayDimension = dimension;
        return (TYPE)((ICompositeTypeGenerator)this.thisInstance());
    }

    @Override
    public Stream<ISourceGenerator<? super ITypeScriptSourceBuilder<?>>> types() {
        return this.m_types.stream();
    }

    @Override
    public TYPE withType(ISourceGenerator<? super ITypeScriptSourceBuilder<?>> type) {
        this.m_types.add((ISourceGenerator)Ensure.notNull(type));
        return (TYPE)((ICompositeTypeGenerator)this.thisInstance());
    }
}

