/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import java.util.HashMap;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.contentassist.ContextInformationValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AttributeContextInformation;
import org.eclipse.wst.xml.ui.internal.contentassist.ContextInfoModelUtil;

public class AttributeContextInformationPresenter
extends ContextInformationValidator
implements IContextInformationPresenter {
    private IContextInformation fInfo = null;
    private ContextInfoModelUtil fModelUtil = null;

    public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
        super.install(info, viewer, documentPosition);
        this.fInfo = info;
        this.fModelUtil = new ContextInfoModelUtil((IStructuredDocument)viewer.getDocument());
    }

    public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
        presentation.clear();
        if (!(this.fInfo instanceof AttributeContextInformation)) {
            return false;
        }
        IDOMNode xmlNode = this.fModelUtil.getXMLNode(documentPosition);
        if (xmlNode == null) {
            return false;
        }
        IStructuredDocumentRegion sdRegion = xmlNode.getFirstStructuredDocumentRegion();
        ITextRegionList regions = sdRegion.getRegions();
        ITextRegion r = null;
        String attrName = "";
        Object temp = null;
        Position p = null;
        HashMap map = ((AttributeContextInformation)this.fInfo).getAttr2RangeMap();
        StyleRange[] sorted = new StyleRange[this.fInfo.getInformationDisplayString().length()];
        int i = 0;
        while (i < regions.size()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME" && (temp = map.get(attrName = sdRegion.getText(r))) != null) {
                p = temp;
                sorted[p.offset] = new StyleRange(p.offset, p.length, null, null, 1);
            }
            ++i;
        }
        StyleRange sr = null;
        int i2 = 0;
        while (i2 < sorted.length) {
            sr = sorted[i2];
            if (sr != null) {
                presentation.addStyleRange(sr);
            }
            ++i2;
        }
        return true;
    }
}

