/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class ObjectCloner {
    private static final WeakHashMap<Class<?>, Optional<Method>> CLONE_METHODS_CACHE = new WeakHashMap();

    public static <T> T deepClone(T obj) {
        return ObjectCloner.deepClone(obj, new IdentityHashMap<Object, Object>());
    }

    private static <T> T deepClone(T obj, Map<Object, @Nullable Object> clones) {
        Object clone = clones.get(obj);
        if (clone != null) {
            return (T)clone;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            List listClone = ObjectCloner.shallowClone(list, () -> new ArrayList(list));
            clones.put(list, listClone);
            listClone.replaceAll(v -> ObjectCloner.deepCloneNullable(v, clones));
            return (T)listClone;
        }
        if (obj instanceof Set) {
            Set set = (Set)obj;
            Set setClone = ObjectCloner.shallowClone(set, HashSet::new);
            clones.put(set, setClone);
            setClone.clear();
            for (Object e : set) {
                setClone.add(ObjectCloner.deepCloneNullable(e, clones));
            }
            return (T)setClone;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            Map mapClone = ObjectCloner.shallowClone(map, () -> new HashMap(map));
            clones.put(map, mapClone);
            mapClone.replaceAll((k, v) -> ObjectCloner.deepCloneNullable(v, clones));
            return (T)mapClone;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            Class<?> arrayType = NullSafetyHelper.castNonNull(obj.getClass().getComponentType());
            Object arrayClone = Array.newInstance(arrayType, len);
            clones.put(obj, arrayClone);
            int i = 0;
            while (i < len) {
                Array.set(arrayClone, i, ObjectCloner.deepCloneNullable(Array.get(obj, i), clones));
                ++i;
            }
            return (T)arrayClone;
        }
        Object shallowClone = ObjectCloner.shallowClone(obj, () -> obj);
        clones.put(obj, shallowClone);
        return obj;
    }

    private static <T> @Nullable T deepCloneNullable(T obj, Map<Object, @Nullable Object> clones) {
        if (obj == null) {
            return null;
        }
        return ObjectCloner.deepClone(obj, clones);
    }

    private static <T> T shallowClone(T obj, Supplier<T> fallback) {
        if (obj instanceof Cloneable) {
            try {
                Optional cloneMethod = CLONE_METHODS_CACHE.computeIfAbsent(obj.getClass(), cls -> {
                    try {
                        return Optional.of(cls.getMethod("clone", new Class[0]));
                    }
                    catch (Exception ex) {
                        return Optional.empty();
                    }
                });
                if (cloneMethod.isPresent()) {
                    return (T)((Method)cloneMethod.get()).invoke(obj, new Object[0]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return fallback.get();
    }

    private ObjectCloner() {
    }
}

