/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;

public class MissingAnnotationAttributesProposalOperation
extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
    private Annotation fAnnotation;

    public MissingAnnotationAttributesProposalOperation(Annotation annotation) {
        this.fAnnotation = annotation;
        Assert.isNotNull((Object)annotation.resolveTypeBinding());
    }

    @Override
    public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
        ListRewrite listRewrite;
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        AST ast = this.fAnnotation.getAST();
        if (this.fAnnotation instanceof NormalAnnotation) {
            listRewrite = rewrite.getListRewrite((ASTNode)this.fAnnotation, NormalAnnotation.VALUES_PROPERTY);
        } else {
            NormalAnnotation newAnnotation = ast.newNormalAnnotation();
            newAnnotation.setTypeName((Name)rewrite.createMoveTarget((ASTNode)this.fAnnotation.getTypeName()));
            rewrite.replace((ASTNode)this.fAnnotation, (ASTNode)newAnnotation, null);
            listRewrite = rewrite.getListRewrite((ASTNode)newAnnotation, NormalAnnotation.VALUES_PROPERTY);
        }
        this.addMissingAtributes(this.fAnnotation.resolveTypeBinding(), listRewrite, cuRewrite, linkedModel);
    }

    private void addMissingAtributes(ITypeBinding binding, ListRewrite listRewriter, CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) {
        HashSet<String> implementedAttribs = new HashSet<String>();
        if (this.fAnnotation instanceof NormalAnnotation) {
            List list = ((NormalAnnotation)this.fAnnotation).values();
            for (MemberValuePair curr : list) {
                implementedAttribs.add(curr.getName().getIdentifier());
            }
        } else if (this.fAnnotation instanceof SingleMemberAnnotation) {
            implementedAttribs.add("value");
        }
        ASTRewrite rewriter = listRewriter.getASTRewrite();
        AST ast = rewriter.getAST();
        ContextSensitiveImportRewriteContext context = null;
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(listRewriter.getParent());
        if (bodyDeclaration != null) {
            context = new ContextSensitiveImportRewriteContext((ASTNode)bodyDeclaration, cuRewrite.getImportRewrite());
        }
        IMethodBinding[] declaredMethods = binding.getDeclaredMethods();
        int i = 0;
        while (i < declaredMethods.length) {
            IMethodBinding curr = declaredMethods[i];
            if (!implementedAttribs.contains(curr.getName()) && curr.getDefaultValue() == null) {
                MemberValuePair pair = ast.newMemberValuePair();
                pair.setName(ast.newSimpleName(curr.getName()));
                pair.setValue(this.newDefaultExpression(ast, curr.getReturnType(), context, cuRewrite.getImportRewrite()));
                listRewriter.insertLast((ASTNode)pair, null);
                linkedModel.getPositionGroup("val_name_" + i, true).addPosition(rewriter.track((ASTNode)pair.getName()), false);
                linkedModel.getPositionGroup("val_type_" + i, true).addPosition(rewriter.track((ASTNode)pair.getValue()), false);
            }
            ++i;
        }
    }

    private Expression newDefaultExpression(AST ast, ITypeBinding type, ImportRewrite.ImportRewriteContext context, ImportRewrite importRewrite) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            return ast.newNumberLiteral("0");
        }
        if (type == ast.resolveWellKnownType("java.lang.String")) {
            return ast.newStringLiteral();
        }
        if (type.isArray()) {
            ArrayInitializer initializer = ast.newArrayInitializer();
            initializer.expressions().add(this.newDefaultExpression(ast, type.getElementType(), context, importRewrite));
            return initializer;
        }
        if (type.isAnnotation()) {
            MarkerAnnotation annotation = ast.newMarkerAnnotation();
            annotation.setTypeName(ast.newName(importRewrite.addImport(type, context)));
            return annotation;
        }
        return ast.newNullLiteral();
    }
}

