/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.nio.file.Path;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.theme.raw.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.raw.RawThemeReader;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IThemeSource;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionLabelProvider;
import org.eclipse.tm4e.ui.internal.widgets.TMViewer;
import org.eclipse.tm4e.ui.internal.widgets.TableWidget;
import org.eclipse.tm4e.ui.internal.widgets.TableWithControlsWidget;
import org.eclipse.tm4e.ui.internal.widgets.VerticalSplitPane;
import org.eclipse.tm4e.ui.snippets.ISnippet;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.Theme;
import org.osgi.service.prefs.BackingStoreException;

public final class ThemePreferencePage
extends AbstractPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.ThemePreferencePage";
    private final IGrammarRegistryManager grammarManager = TMEclipseRegistryPlugin.getGrammarRegistryManager();
    private IThemeManager.EditSession themeManager = ThemeManager.getInstance().newEditSession();
    private TableWidget<ITheme> themesTable = (TableWidget)((Object)NullSafetyHelper.lateNonNull());
    private ComboViewer grammarsCombo = (ComboViewer)NullSafetyHelper.lateNonNull();
    private TMViewer themePreview = (TMViewer)((Object)NullSafetyHelper.lateNonNull());

    public ThemePreferencePage() {
        super(TMUIMessages.ThemePreferencePage_title, TMUIMessages.ThemePreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        Control control = new VerticalSplitPane(parent, 1, 1){

            @Override
            protected void configureUpperArea(Composite parent) {
                ThemePreferencePage.this.createThemesTable(parent);
                ThemePreferencePage.this.createThemeDetailsView(parent);
            }

            @Override
            protected void configureLowerArea(Composite parent) {
                ThemePreferencePage.this.createThemePreview(parent);
            }
        }.getControl();
        Dialog.applyDialogFont((Control)control);
        this.themesTable.setInput(this.themeManager);
        return control;
    }

    private void createThemesTable(Composite parent) {
        TableWithControlsWidget<ITheme> tableWithControls = new TableWithControlsWidget<ITheme>(parent, null, true){

            @Override
            protected TableWidget<ITheme> createTable(Composite parent) {
                return new TableWidget<ITheme>(parent, false){

                    @Override
                    protected void createColumns() {
                        this.createAutoResizeColumn(TMUIMessages.ThemePreferencePage_column_name, new int[0]);
                        this.createAutoResizeColumn(TMUIMessages.ThemePreferencePage_column_type, 0);
                        this.createAutoResizeColumn(TMUIMessages.ThemePreferencePage_column_source, 0);
                    }

                    protected @Nullable String getColumnText(ITheme theme, int columnIndex) {
                        return switch (columnIndex) {
                            case 0 -> theme.getName();
                            case 1 -> {
                                if (theme.isDark()) {
                                    yield "dark";
                                }
                                yield "light";
                            }
                            case 2 -> (String)(theme.getPluginId() == null ? "" : theme.getPluginId() + " > ") + theme.getPath();
                            default -> null;
                        };
                    }

                    @Override
                    protected Object[] getElements(@Nullable Object input) {
                        if (input instanceof IThemeManager) {
                            IThemeManager themeManager = (IThemeManager)input;
                            return themeManager.getThemes();
                        }
                        return super.getElements(input);
                    }
                };
            }

            @Override
            protected void createButtons() {
                this.createButton(TMUIMessages.Button_new, () -> {
                    ITheme newTheme = this.openBrowseForThemeDialog();
                    if (newTheme != null) {
                        ThemePreferencePage.this.themeManager.registerTheme(newTheme);
                        this.table.refresh();
                        this.table.setSelection(true, (T[])new ITheme[]{newTheme});
                    }
                });
                Button removeBtn = this.createButton(TMUIMessages.Button_remove, () -> {
                    ITheme selectedTheme = (ITheme)this.table.getFirstSelectedElement();
                    if (selectedTheme != null) {
                        ThemePreferencePage.this.themeManager.unregisterTheme(selectedTheme);
                        this.table.refresh();
                    }
                });
                this.table.onSelectionChanged(sel -> removeBtn.setEnabled(!sel.isEmpty() && ((ITheme)sel.get(0)).getPluginId() == null));
            }

            private @Nullable ITheme openBrowseForThemeDialog() {
                FileDialog dialog = new FileDialog(this.getShell());
                dialog.setText("Select textmate theme file");
                dialog.setFilterExtensions(new String[]{"*.css;*.json;*.plist;*.tmTheme;*.YAML-tmTheme"});
                String res = dialog.open();
                if (res == null) {
                    return null;
                }
                Path themePath = Path.of(res, new String[0]);
                String themeFileName = themePath.getFileName().toString();
                try {
                    IRawTheme rawTheme = RawThemeReader.readTheme((IThemeSource)IThemeSource.fromFile((Path)themePath));
                    String rawThemeName = rawTheme.getName();
                    String name = rawThemeName == null ? themeFileName.substring(0, themeFileName.lastIndexOf(46)) : rawThemeName;
                    return new Theme(name, themePath.toAbsolutePath().toString(), name, false);
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Invalid theme file", (String)("Failed to parse [" + String.valueOf(themePath) + "]: " + String.valueOf(ex)));
                    return null;
                }
            }
        };
        tableWithControls.setLayoutData(GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(360, this.convertHeightInCharsToPixels(10)).create());
        this.themesTable = tableWithControls.getTable();
    }

    private void createThemeDetailsView(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        parent.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        parent.setLayout((Layout)layout);
        Button darkThemeButton = new Button(parent, 32);
        darkThemeButton.setText(TMUIMessages.ThemePreferencePage_darkThemeButton_label);
        darkThemeButton.setEnabled(false);
        Button defaultThemeButton = new Button(parent, 32);
        defaultThemeButton.setText(TMUIMessages.ThemePreferencePage_defaultThemeButton_label);
        defaultThemeButton.setEnabled(true);
        defaultThemeButton.addListener(13, e -> {
            ITheme selectedTheme = this.themesTable.getFirstSelectedElement();
            if (selectedTheme != null) {
                this.themeManager.setDefaultTheme(selectedTheme.getId(), selectedTheme.isDark());
            }
        });
        this.themesTable.onSelectionChanged(themes -> {
            if (themes.isEmpty()) {
                darkThemeButton.setSelection(false);
                defaultThemeButton.setSelection(false);
                defaultThemeButton.setEnabled(false);
                return;
            }
            ITheme selectedTheme = (ITheme)themes.get(0);
            darkThemeButton.setSelection(selectedTheme.isDark());
            darkThemeButton.setEnabled(selectedTheme.getPluginId() == null);
            defaultThemeButton.setSelection(this.themeManager.getDefaultTheme(selectedTheme.isDark()) == selectedTheme);
        });
    }

    private void createThemePreview(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.ThemePreferencePage_preview);
        this.grammarsCombo = new ComboViewer(parent);
        this.grammarsCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.grammarsCombo.setLabelProvider((IBaseLabelProvider)new GrammarDefinitionLabelProvider());
        this.grammarsCombo.setComparator(new ViewerComparator());
        this.grammarsCombo.addSelectionChangedListener(e -> this.preview());
        this.grammarsCombo.getControl().setLayoutData((Object)new GridData(768));
        this.grammarsCombo.setInput((Object)Stream.of(this.grammarManager.getDefinitions()).filter(grammar -> TMUIPlugin.getSnippetManager().getSnippets(grammar.getScope().getName()).length > 0).toArray());
        if (this.grammarsCombo.getCombo().getItemCount() > 0) {
            this.grammarsCombo.getCombo().select(0);
        }
        this.themePreview = new TMViewer(parent, 2816);
        Control control = this.themePreview.getControl();
        control.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, this.convertHeightInCharsToPixels(5)).create());
        this.themesTable.onSelectionChanged(themes -> this.preview());
    }

    private void preview() {
        @Nullable ITheme theme = this.themesTable.getFirstSelectedElement();
        if (theme == null) {
            return;
        }
        IStructuredSelection selection = this.grammarsCombo.getStructuredSelection();
        Object object = selection.getFirstElement();
        if (object instanceof IGrammarDefinition) {
            IGrammarDefinition definition = (IGrammarDefinition)object;
            IGrammar grammar = this.grammarManager.getGrammarForScope(definition.getScope());
            this.themePreview.setTheme(theme);
            this.themePreview.setGrammar(grammar);
            ISnippet[] snippets = TMUIPlugin.getSnippetManager().getSnippets(definition.getScope().getName());
            if (snippets.length == 0) {
                this.themePreview.setText("");
            } else {
                this.themePreview.setText(snippets[0].getContent());
            }
        }
    }

    protected void performDefaults() {
        this.themeManager = ThemeManager.getInstance().newEditSession();
        this.themesTable.setInput(this.themeManager);
    }

    public boolean performOk() {
        try {
            this.themeManager.save();
        }
        catch (BackingStoreException ex) {
            TMUIPlugin.logError((Exception)((Object)ex));
            return false;
        }
        return super.performOk();
    }
}

