/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.equinox.p2.artifact.repository";
    public static final String ENABLE_ARTIFACT_LOCKING = "eclipse.p2.internal.simple.artifact.repository.locking";
    public static final String REPO_PROVIDER_XPT = "org.eclipse.equinox.p2.artifact.repository.artifactRepositories";
    private Map<URI, Location> locationCache = null;
    private static BundleContext context;
    private static Activator instance;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext aContext) throws Exception {
        context = aContext;
        instance = this;
        this.locationCache = new HashMap<URI, Location>();
    }

    public void stop(BundleContext aContext) throws Exception {
        context = null;
        instance = null;
        this.locationCache = null;
    }

    public static Activator getInstance() {
        return instance;
    }

    public boolean enableArtifactLocking() {
        String property = Activator.getContext().getProperty(ENABLE_ARTIFACT_LOCKING);
        if (property == null || property.length() == 0) {
            return false;
        }
        Boolean valueOf = Boolean.valueOf(property);
        if (valueOf != null) {
            return valueOf;
        }
        return false;
    }

    public synchronized Location getLockLocation(URI repositoryLocation) throws IOException {
        if (this.locationCache.containsKey(repositoryLocation)) {
            return this.locationCache.get(repositoryLocation);
        }
        Location anyLoc = (Location)ServiceHelper.getService((BundleContext)Activator.getContext(), Location.class);
        File repositoryFile = URIUtil.toFile((URI)repositoryLocation);
        Location location = anyLoc.createLocation(null, this.getLockFile(repositoryLocation).toURL(), this.isReadOnly(repositoryFile));
        location.set(this.getLockFile(repositoryLocation).toURL(), false);
        this.locationCache.put(repositoryLocation, location);
        return location;
    }

    private boolean isReadOnly(File file) {
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            return !Files.isWritable(file.toPath());
        }
        return this.isReadOnly(file.getParentFile());
    }

    private File getLockFile(URI repositoryLocation) throws IOException {
        if (!URIUtil.isFileURI((URI)repositoryLocation)) {
            throw new IOException(String.format("Cannot lock a non file based repository %s", repositoryLocation));
        }
        URI result = URIUtil.append((URI)repositoryLocation, (String)".artifactlock");
        return URIUtil.toFile((URI)result);
    }
}

