/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class ModuleFolder
implements IModuleFolder {
    private static final IModuleResource[] EMPTY_RESOURCE_ARRAY = new IModuleResource[0];
    private IContainer container;
    private String name;
    private IPath path;
    private IModuleResource[] members;

    public ModuleFolder(IContainer container, String name, IPath path) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.container = container;
        this.name = name;
        this.path = path;
    }

    public void setMembers(IModuleResource[] members) {
        this.members = members;
    }

    @Override
    public IPath getModuleRelativePath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IModuleResource[] members() {
        if (this.members == null) {
            return EMPTY_RESOURCE_ARRAY;
        }
        return this.members;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModuleFolder)) {
            return false;
        }
        ModuleFolder mf = (ModuleFolder)obj;
        if (!this.name.equals(mf.name)) {
            return false;
        }
        return this.path.equals((Object)mf.path);
    }

    public int hashCode() {
        return this.name.hashCode() * 37 + this.path.hashCode();
    }

    public Object getAdapter(Class cl) {
        if (IContainer.class.equals((Object)cl) || IFolder.class.equals((Object)cl)) {
            return this.container;
        }
        return null;
    }

    public String toString() {
        return "ModuleFolder [" + this.name + ", " + this.path + "]";
    }
}

