/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ZipEntryStorage;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupMessages;
import org.eclipse.debug.internal.core.sourcelookup.SourceLookupUtils;

public class ExternalArchiveSourceContainer
extends AbstractSourceContainer {
    private boolean fDisposed;
    private final boolean fDetectRoots;
    private Set<String> fPotentialRoots;
    private final List<String> fRoots = new ArrayList<String>();
    private final String fArchivePath;
    public static final String TYPE_ID = DebugPlugin.getUniqueIdentifier() + ".containerType.externalArchive";

    public ExternalArchiveSourceContainer(String archivePath, boolean detectRootPaths) {
        this.fArchivePath = archivePath;
        this.fDetectRoots = detectRootPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] findSourceElements(String name) throws CoreException {
        String newname = name.replace('\\', '/');
        ZipFile file = this.getArchive();
        if (file == null) {
            return EMPTY;
        }
        ZipFile zipFile = file;
        synchronized (zipFile) {
            boolean isQualfied;
            boolean bl = isQualfied = newname.indexOf(47) > 0;
            if (this.fDetectRoots && isQualfied) {
                ZipEntry entry = this.searchRoots(file, newname);
                if (entry != null) {
                    return new Object[]{new ZipEntryStorage(file, entry)};
                }
            } else {
                ZipEntry entry = null;
                try {
                    entry = file.getEntry(newname);
                }
                catch (IllegalStateException e) {
                    throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e));
                }
                if (entry != null) {
                    return new Object[]{new ZipEntryStorage(file, entry)};
                }
                Enumeration<? extends ZipEntry> entries = file.entries();
                ArrayList<ZipEntryStorage> matches = null;
                try {
                    File zipFile2 = new File(this.fArchivePath);
                    String zipFileCanonical = zipFile2.getCanonicalPath();
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.endsWith(newname)) continue;
                        String zipEntryCanonical = new File(zipFile2, entryName).getCanonicalPath();
                        if (!zipEntryCanonical.startsWith(zipFileCanonical + File.separator)) {
                            throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), "Invalid path: " + zipEntryCanonical));
                        }
                        if (!isQualfied && entryName.length() != newname.length() && entryName.charAt(entryName.length() - newname.length() - 1) != '/') continue;
                        if (this.isFindDuplicates()) {
                            if (matches == null) {
                                matches = new ArrayList<ZipEntryStorage>();
                            }
                            matches.add(new ZipEntryStorage(file, entry));
                            continue;
                        }
                        return new Object[]{new ZipEntryStorage(file, entry)};
                    }
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), "Invalid path: " + this.fArchivePath));
                }
                if (matches != null) {
                    return matches.toArray();
                }
            }
        }
        return EMPTY;
    }

    private synchronized ZipEntry searchRoots(ZipFile file, String name) throws CoreException {
        if (this.fDisposed) {
            return null;
        }
        if (this.fPotentialRoots == null) {
            this.fPotentialRoots = new HashSet<String>();
            this.fPotentialRoots.add("");
            try {
                Enumeration<? extends ZipEntry> entries = file.entries();
                block2: while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) {
                        this.fPotentialRoots.add(entry.getName());
                        continue;
                    }
                    String entryName = entry.getName();
                    int index = entryName.lastIndexOf(47);
                    while (index > 0) {
                        if (!this.fPotentialRoots.add(entryName.substring(0, index + 1))) continue block2;
                        entryName = entryName.substring(0, index);
                        index = entryName.lastIndexOf(47);
                    }
                }
            }
            catch (IllegalStateException e) {
                throw new CoreException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e));
            }
        }
        int i = 0;
        while (i < this.fRoots.size()) {
            String root = this.fRoots.get(i);
            ZipEntry entry = file.getEntry(root + name);
            if (entry != null) {
                return entry;
            }
            ++i;
        }
        if (!this.fPotentialRoots.isEmpty()) {
            for (String root : this.fPotentialRoots) {
                ZipEntry entry = file.getEntry(root + name);
                if (entry == null) continue;
                if (root != null) {
                    this.fRoots.add(root);
                    this.fPotentialRoots.remove(root);
                    Iterator<String> rs = this.fPotentialRoots.iterator();
                    while (rs.hasNext()) {
                        String r = rs.next();
                        if (!r.startsWith(root)) continue;
                        rs.remove();
                    }
                }
                return entry;
            }
        }
        return null;
    }

    private synchronized ZipFile getArchive() throws CoreException {
        if (this.fDisposed) {
            return null;
        }
        try {
            return SourceLookupUtils.getZipFile(this.fArchivePath);
        }
        catch (IOException e) {
            File file = new File(this.fArchivePath);
            if (file.exists()) {
                this.abort(MessageFormat.format(SourceLookupMessages.ExternalArchiveSourceContainer_2, this.fArchivePath), e);
            } else {
                this.warn(MessageFormat.format(SourceLookupMessages.ExternalArchiveSourceContainer_1, this.fArchivePath), e);
            }
            return null;
        }
    }

    @Override
    public String getName() {
        return this.fArchivePath;
    }

    @Override
    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public boolean isDetectRoot() {
        return this.fDetectRoots;
    }

    public boolean equals(Object obj) {
        return obj instanceof ExternalArchiveSourceContainer && ((ExternalArchiveSourceContainer)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fPotentialRoots != null) {
            this.fPotentialRoots.clear();
        }
        this.fRoots.clear();
        this.fDisposed = true;
    }
}

