/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.IOException;
import org.apache.http.client.methods.HttpRequestBase;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpOperation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.commons.repositories.http.core.HttpRequestProcessor;

class DefaultHttpOperation<T>
extends CommonHttpOperation<T> {
    private final HttpRequestProcessor<T> processor;
    private final HttpRequestBase request;

    public DefaultHttpOperation(CommonHttpClient client, HttpRequestBase request, HttpRequestProcessor<T> processor) {
        super(client);
        Assert.isNotNull(processor);
        this.request = request;
        this.processor = processor;
    }

    public T run(IOperationMonitor monitor) throws IOException {
        CommonHttpResponse response = this.execute(this.request, monitor);
        return this.processor.autoRelease() ? this.processAndRelease(response, monitor) : this.process(response, monitor);
    }

    protected T doProcess(CommonHttpResponse response, IOperationMonitor monitor) throws IOException {
        return this.processor.doProcess(response, monitor);
    }

    protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException {
        this.processor.doValidate(response, monitor);
    }

    protected T process(CommonHttpResponse response, IOperationMonitor monitor) throws IOException {
        try {
            this.doValidate(response, monitor);
            return this.doProcess(response, monitor);
        }
        catch (IOException | RuntimeException e) {
            response.release((IProgressMonitor)monitor);
            throw e;
        }
    }

    protected T processAndRelease(CommonHttpResponse response, IOperationMonitor monitor) throws IOException {
        try {
            this.doValidate(response, monitor);
            T t = this.doProcess(response, monitor);
            return t;
        }
        finally {
            response.release((IProgressMonitor)monitor);
        }
    }
}

