/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.ui;

import com.ibm.icu.text.NumberFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.SelectionConverter;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;

public class OffsetStatusLineContributionItem
extends StatusLineContributionItem {
    static final String[] TEMPORARY_ANNOTATION_KEYS = new String[]{"Partition Type", "Step", "Scope", "Offset", "Length", "Description"};
    IAction fShowEditorInformationAction = new ShowEditorInformationAction();
    ITextEditor fTextEditor = null;

    public OffsetStatusLineContributionItem(String id) {
        super(id);
        this.setToolTipText("Double-click for more information");
    }

    public OffsetStatusLineContributionItem(String id, boolean visible, int widthInChars) {
        super(id, visible, widthInChars);
        this.setToolTipText("Double-click for more information");
    }

    public void setActiveEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
        this.setActionHandler(this.fShowEditorInformationAction);
    }

    class AnnotationPropertySource
    implements IPropertySource {
        Annotation fAnnotation = null;
        IPropertyDescriptor[] fDescriptors = null;

        public AnnotationPropertySource(Annotation annotation) {
            this.fAnnotation = annotation;
        }

        public Object getEditableValue() {
            return null;
        }

        public IPropertyDescriptor[] getPropertyDescriptors() {
            if (this.fDescriptors == null) {
                try {
                    Object key;
                    if (this.fAnnotation instanceof SimpleMarkerAnnotation) {
                        Map attrs = ((SimpleMarkerAnnotation)this.fAnnotation).getMarker().getAttributes();
                        Object[] keys = attrs.keySet().toArray();
                        this.fDescriptors = new IPropertyDescriptor[keys.length];
                        int i = 0;
                        while (i < keys.length) {
                            TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)keys[i].toString(), keys[i].toString());
                            this.fDescriptors[i] = descriptor;
                            ++i;
                        }
                    } else if (this.fAnnotation instanceof TemporaryAnnotation && (key = ((TemporaryAnnotation)this.fAnnotation).getKey()) != null && key instanceof ReconcileAnnotationKey) {
                        String[] keys = TEMPORARY_ANNOTATION_KEYS;
                        this.fDescriptors = new IPropertyDescriptor[keys.length];
                        int i = 0;
                        while (i < keys.length) {
                            TextPropertyDescriptor descriptor = new TextPropertyDescriptor((Object)keys[i].toString(), keys[i].toString());
                            this.fDescriptors[i] = descriptor;
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (this.fDescriptors == null) {
                this.fDescriptors = new IPropertyDescriptor[0];
            }
            return this.fDescriptors;
        }

        public Object getPropertyValue(Object id) {
            String value = null;
            if (this.fAnnotation instanceof SimpleMarkerAnnotation) {
                try {
                    Object o = ((SimpleMarkerAnnotation)this.fAnnotation).getMarker().getAttributes().get(id);
                    if (o != null) {
                        value = o.toString();
                    }
                }
                catch (CoreException coreException) {}
            } else if (this.fAnnotation instanceof TemporaryAnnotation) {
                if (TEMPORARY_ANNOTATION_KEYS[0].equals(id)) {
                    Object key = ((TemporaryAnnotation)this.fAnnotation).getKey();
                    if (key != null && key instanceof ReconcileAnnotationKey) {
                        value = ((ReconcileAnnotationKey)key).getPartitionType();
                    }
                } else if (TEMPORARY_ANNOTATION_KEYS[1].equals(id)) {
                    IReconcileStep step;
                    Object key = ((TemporaryAnnotation)this.fAnnotation).getKey();
                    if (key != null && key instanceof ReconcileAnnotationKey && (step = ((ReconcileAnnotationKey)key).getStep()) != null) {
                        value = step.toString();
                    }
                } else if (TEMPORARY_ANNOTATION_KEYS[2].equals(id)) {
                    Object key = ((TemporaryAnnotation)this.fAnnotation).getKey();
                    if (key != null && key instanceof ReconcileAnnotationKey) {
                        int scope = ((ReconcileAnnotationKey)key).getScope();
                        if (scope == 1) {
                            value = "PARTIAL";
                        }
                        if (scope == 0) {
                            value = "TOTAL";
                        }
                    }
                } else if (TEMPORARY_ANNOTATION_KEYS[3].equals(id)) {
                    IAnnotationModel annotationModel = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput());
                    Position p = annotationModel.getPosition(this.fAnnotation);
                    if (p != null) {
                        value = String.valueOf(p.getOffset());
                    }
                } else if (TEMPORARY_ANNOTATION_KEYS[4].equals(id)) {
                    IAnnotationModel annotationModel = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput());
                    Position p = annotationModel.getPosition(this.fAnnotation);
                    if (p != null) {
                        value = String.valueOf(p.getLength());
                    }
                } else if (TEMPORARY_ANNOTATION_KEYS[5].equals(id)) {
                    value = ((TemporaryAnnotation)this.fAnnotation).getDescription();
                }
            }
            return value;
        }

        public boolean isPropertySet(Object id) {
            return false;
        }

        public void resetPropertyValue(Object id) {
            try {
                if (this.fAnnotation instanceof SimpleMarkerAnnotation) {
                    ((SimpleMarkerAnnotation)this.fAnnotation).getMarker().getAttributes().remove(id);
                } else {
                    boolean cfr_ignored_0 = this.fAnnotation instanceof TemporaryAnnotation;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void setPropertyValue(Object id, Object value) {
            try {
                if (this.fAnnotation instanceof SimpleMarkerAnnotation) {
                    ((MarkerAnnotation)this.fAnnotation).getMarker().setAttribute(id.toString(), value);
                } else {
                    boolean cfr_ignored_0 = this.fAnnotation instanceof TemporaryAnnotation;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    class InformationDialog
    extends Dialog {
        IDocument fDocument;

        public InformationDialog(Shell parentShell) {
            super(parentShell);
            this.fDocument = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getDocument((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput());
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        private void createAnnotationTabContents(Composite annotationsTabComposite) {
            IAnnotationModel annotationModel;
            annotationsTabComposite.setLayout((Layout)new GridLayout());
            annotationsTabComposite.setLayoutData((Object)new GridData());
            final Composite annotationsComposite = new Composite(annotationsTabComposite, 0);
            annotationsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            TableViewer annotationsTable = new TableViewer(annotationsComposite, 68356);
            annotationsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            annotationsTable.getTable().setHeaderVisible(true);
            annotationsTable.getTable().setLinesVisible(true);
            String[] columns = new String[]{"Line", "Owner", "Type", "Class", "Message"};
            annotationsTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    Annotation annotation = (Annotation)element;
                    String text = null;
                    switch (columnIndex) {
                        case 0: {
                            text = InformationDialog.this.getLineNumber(annotation);
                            break;
                        }
                        case 1: {
                            text = this.getOwner(annotation);
                            break;
                        }
                        case 2: {
                            text = this.getType(annotation);
                            break;
                        }
                        case 3: {
                            text = annotation.getClass().getName();
                            break;
                        }
                        case 4: {
                            text = annotation.getText();
                        }
                    }
                    if (text == null) {
                        text = "";
                    }
                    return text;
                }

                private String getOwner(Annotation annotation) {
                    Object key;
                    String owner = null;
                    if (annotation instanceof MarkerAnnotation) {
                        owner = ((MarkerAnnotation)annotation).getMarker().getAttribute("owner", "");
                    } else if (annotation instanceof TemporaryAnnotation && (key = ((TemporaryAnnotation)annotation).getKey()) != null) {
                        if (key instanceof ReconcileAnnotationKey) {
                            key = key.getClass().getName();
                        }
                        if (key != null) {
                            owner = key.toString();
                        }
                    }
                    return owner;
                }

                private String getType(Annotation annotation) {
                    String type = null;
                    type = annotation instanceof MarkerAnnotation ? "M:" + MarkerUtilities.getMarkerType((IMarker)((MarkerAnnotation)annotation).getMarker()) : "A:" + annotation.getType();
                    if (type == null) {
                        type = "";
                    }
                    return type;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            TableLayout tlayout = new TableLayout();
            CellEditor[] cellEditors = new CellEditor[columns.length];
            int[] columnWidths = new int[]{Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 7, Display.getCurrent().getBounds().width / 7, Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 7};
            int i = 0;
            while (i < columns.length) {
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
                TableColumn tc = new TableColumn(annotationsTable.getTable(), 0);
                tc.setText(columns[i]);
                tc.setResizable(true);
                tc.setWidth(columnWidths[i]);
                ++i;
            }
            annotationsTable.setCellEditors(cellEditors);
            annotationsTable.setColumnProperties(columns);
            ArrayList<Annotation> matchingAnnotations = new ArrayList<Annotation>(0);
            if (OffsetStatusLineContributionItem.this.fTextEditor != null && (annotationModel = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput())) != null) {
                Iterator iterator = annotationModel.getAnnotationIterator();
                while (iterator.hasNext()) {
                    Annotation element = (Annotation)iterator.next();
                    matchingAnnotations.add(element);
                }
            }
            Collections.sort(matchingAnnotations, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Annotation annotation1 = (Annotation)o1;
                    Annotation annotation2 = (Annotation)o2;
                    String line1 = InformationDialog.this.getLineNumber(annotation1);
                    String line2 = InformationDialog.this.getLineNumber(annotation2);
                    return Integer.parseInt(line1) - Integer.parseInt(line2);
                }
            });
            annotationsTable.setInput(matchingAnnotations);
            Sash sash = new Sash(annotationsComposite, 256);
            final PropertySheetPage propertySheet = new PropertySheetPage();
            propertySheet.createControl(annotationsComposite);
            propertySheet.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof Annotation) {
                        AnnotationPropertySource annotationPropertySource = new AnnotationPropertySource((Annotation)object);
                        return annotationPropertySource;
                    }
                    return null;
                }
            });
            annotationsTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    propertySheet.selectionChanged(null, event.getSelection());
                }
            });
            FormLayout form = new FormLayout();
            annotationsComposite.setLayout((Layout)form);
            FormData tableData = new FormData();
            tableData.top = new FormAttachment(0, 0);
            tableData.bottom = new FormAttachment((Control)sash, 2);
            tableData.left = new FormAttachment(0, 0);
            tableData.right = new FormAttachment(100, 0);
            annotationsTable.getControl().setLayoutData((Object)tableData);
            FormData propertiesData = new FormData();
            propertiesData.top = new FormAttachment((Control)sash, 2);
            propertiesData.left = new FormAttachment(0, 0);
            propertiesData.right = new FormAttachment(100, 0);
            propertiesData.bottom = new FormAttachment(100, 0);
            propertySheet.getControl().setLayoutData((Object)propertiesData);
            final FormData sashData = new FormData();
            sashData.top = new FormAttachment(60, 0);
            sashData.left = new FormAttachment(0, 0);
            sashData.right = new FormAttachment(100, 0);
            sash.setLayoutData((Object)sashData);
            sash.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    sashData.top = new FormAttachment(0, e.y);
                    annotationsComposite.layout();
                }
            });
            annotationsComposite.pack(true);
        }

        protected Control createDialogArea(Composite parent) {
            IWorkbenchWindow window;
            IEditorSite site;
            ISelection selection = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
            ITextSelection textSelection = (ITextSelection)selection;
            IStructuredSelection structuredSelection = null;
            if (selection instanceof IStructuredSelection) {
                structuredSelection = (IStructuredSelection)selection;
            }
            parent.getShell().setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_0) + textSelection.getOffset() + "-" + (textSelection.getOffset() + textSelection.getLength()));
            Composite composite = (Composite)super.createDialogArea(parent);
            Text documentTypeLabel = new Text(composite, 12);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            documentTypeLabel.setLayoutData((Object)gd);
            documentTypeLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_6) + this.fDocument.getClass().getName());
            documentTypeLabel.setBackground(composite.getBackground());
            Text documentProviderLabel = new Text(composite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            documentProviderLabel.setLayoutData((Object)gd);
            documentProviderLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_7) + OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getClass().getName());
            documentProviderLabel.setBackground(composite.getBackground());
            Text selectionConverter = new Text(composite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            selectionConverter.setLayoutData((Object)gd);
            selectionConverter.setBackground(composite.getBackground());
            Text editorInputLabel = new Text(composite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            editorInputLabel.setLayoutData((Object)gd);
            editorInputLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_12) + OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput().getClass().getName());
            editorInputLabel.setBackground(composite.getBackground());
            final Text bomLabel = new Text(composite, 12);
            gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            bomLabel.setLayoutData((Object)gd);
            bomLabel.setEnabled(false);
            bomLabel.setText("Byte Order Mark: ");
            bomLabel.setBackground(composite.getBackground());
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            if (model != null) {
                selectionConverter.setText("Selection Converter class: " + ((SelectionConverter)model.getAdapter(SelectionConverter.class)).getClass().getName());
                Text modelIdLabel = new Text(composite, 12);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                modelIdLabel.setLayoutData((Object)gd);
                modelIdLabel.setText("ID: " + model.getId());
                modelIdLabel.setBackground(composite.getBackground());
                Text modelBaseLocationLabel = new Text(composite, 12);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                modelBaseLocationLabel.setLayoutData((Object)gd);
                modelBaseLocationLabel.setText("Base Location: " + model.getBaseLocation());
                modelBaseLocationLabel.setBackground(composite.getBackground());
                Text modelContentTypeLabel = new Text(composite, 12);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                modelContentTypeLabel.setLayoutData((Object)gd);
                modelContentTypeLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_4) + model.getContentTypeIdentifier());
                modelContentTypeLabel.setBackground(composite.getBackground());
                Text modelHandlerContentTypeLabel = new Text(composite, 74);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                modelHandlerContentTypeLabel.setLayoutData((Object)gd);
                modelHandlerContentTypeLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_5) + model.getModelHandler().getAssociatedContentTypeId() + " (" + model.getModelHandler() + ")");
                modelHandlerContentTypeLabel.setBackground(composite.getBackground());
                Text encodingLabel = new Text(composite, 74);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                encodingLabel.setLayoutData((Object)gd);
                encodingLabel.setText(model.getStructuredDocument().getEncodingMemento().toString());
                encodingLabel.setBackground(composite.getBackground());
                final Text counts = new Text(composite, 74);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                counts.setLayoutData((Object)gd);
                counts.setText("Counting...");
                counts.setEnabled(false);
                counts.setBackground(composite.getBackground());
                final IStructuredModel finalModel = model;
                final Display display = Display.getCurrent();
                Job counter = new Job("Counting regions"){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStructuredDocumentRegion[] structuredDocumentRegions = finalModel.getStructuredDocument().getStructuredDocumentRegions();
                        int length = finalModel.getStructuredDocument().getLength();
                        int regionCount = 0;
                        int i = 0;
                        while (i < structuredDocumentRegions.length) {
                            regionCount += structuredDocumentRegions[i].getNumberOfRegions();
                            ++i;
                        }
                        NumberFormat formatter = NumberFormat.getIntegerInstance();
                        final String regioncount = "Count: " + formatter.format((long)structuredDocumentRegions.length) + " document regions containing " + formatter.format((long)regionCount) + " text regions representing " + formatter.format((long)length) + " characters";
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!counts.isDisposed()) {
                                    counts.setText(regioncount);
                                    counts.setEnabled(true);
                                }
                                if (!bomLabel.isDisposed()) {
                                    bomLabel.setText("Byte Order Mark: " + InformationDialog.this.getBOMText(((InformationDialog)(this).InformationDialog.this).OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput()));
                                    bomLabel.setEnabled(true);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                counter.schedule(1000L);
                Label blankRow = new Label(composite, 0);
                gd = new GridData(4, 4, true, false);
                gd.horizontalSpan = 2;
                blankRow.setLayoutData((Object)gd);
            }
            if (model != null) {
                model.releaseFromRead();
            }
            TabFolder tabfolder = new TabFolder(composite, 0);
            tabfolder.setLayoutData((Object)new GridData(1808));
            TabItem partitionTab = new TabItem(tabfolder, 2048);
            partitionTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_2);
            SashForm partitions = new SashForm((Composite)tabfolder, 0);
            partitions.setOrientation(512);
            partitionTab.setControl((Control)partitions);
            this.createPartitionTabContents(partitions);
            partitions.setWeights(new int[]{2, 1});
            TabItem annotationsTab = new TabItem(tabfolder, 2048);
            annotationsTab.setText("Annotations");
            Composite annotations = new Composite((Composite)tabfolder, 0);
            annotationsTab.setControl((Control)annotations);
            this.createAnnotationTabContents(annotations);
            if (this.fDocument instanceof IStructuredDocument) {
                TabItem regionTab = new TabItem(tabfolder, 2048);
                regionTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_3);
                SashForm regions = new SashForm((Composite)tabfolder, 0);
                regions.setOrientation(256);
                regionTab.setControl((Control)regions);
                this.createRegionTabContents(regions);
                regions.setWeights(new int[]{3, 2});
            }
            if (structuredSelection != null) {
                TabItem editorSelectionTab = new TabItem(tabfolder, 2048);
                editorSelectionTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_14);
                Composite editorSelectionComposite = new Composite((Composite)tabfolder, 0);
                editorSelectionTab.setControl((Control)editorSelectionComposite);
                this.fillSelectionTabContents(editorSelectionComposite, structuredSelection.toList(), "Class: " + structuredSelection.getClass().getName());
            }
            if ((model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument)) != null) {
                TabItem overlappingIndexedRegionsTab = new TabItem(tabfolder, 2048);
                overlappingIndexedRegionsTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_20);
                Composite overlappingIndexedRegionsTabComposite = new Composite((Composite)tabfolder, 0);
                overlappingIndexedRegionsTab.setControl((Control)overlappingIndexedRegionsTabComposite);
                this.fillSelectionTabContents(overlappingIndexedRegionsTabComposite, this.getIndexedRegions(textSelection), "All IndexedRegions overlapping text selection");
                model.releaseFromRead();
            }
            if ((site = OffsetStatusLineContributionItem.this.fTextEditor.getEditorSite()) != null && (window = site.getWorkbenchWindow()) != null) {
                ISelectionService service = window.getSelectionService();
                ISelection selectionFromService = service.getSelection();
                if (service != null && !selectionFromService.equals(structuredSelection) && selectionFromService instanceof IStructuredSelection) {
                    TabItem selectionServiceTab = new TabItem(tabfolder, 2048);
                    selectionServiceTab.setText(SSEUIMessages.OffsetStatusLineContributionItem_19);
                    Composite selectionServiceComposite = new Composite((Composite)tabfolder, 0);
                    selectionServiceTab.setControl((Control)selectionServiceComposite);
                    this.fillSelectionTabContents(selectionServiceComposite, ((IStructuredSelection)selectionFromService).toList(), "Class: " + selectionFromService.getClass().getName());
                }
            }
            return composite;
        }

        private String getBOMText(IEditorInput editorInput) {
            String detectedBOM;
            block22: {
                IFile file = (IFile)editorInput.getAdapter(IFile.class);
                detectedBOM = "none";
                if (file != null) {
                    InputStream s = null;
                    try {
                        try {
                            s = file.getContents(true);
                            if (s != null) {
                                int b1 = s.read() & 0xFF;
                                int b2 = s.read() & 0xFF;
                                if (b1 == 254 && b2 == 255) {
                                    detectedBOM = "FE FF (UTF-16BE)";
                                } else if (b1 == 255 && b2 == 254) {
                                    detectedBOM = "FF FE (UTF-16LE)";
                                } else {
                                    int b3 = s.read() & 0xFF;
                                    if (b1 == 239 && b2 == 187 && b3 == 191) {
                                        detectedBOM = "EF BB BF (UTF-8)";
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            detectedBOM = e.getMessage();
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    detectedBOM = "N/A";
                }
            }
            return detectedBOM;
        }

        private List getIndexedRegions(ITextSelection textSelection) {
            ArrayList<IndexedRegion> overlappingIndexedRegions = new ArrayList<IndexedRegion>(2);
            int start = textSelection.getOffset();
            int end = start + textSelection.getLength();
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.fDocument);
            if (model != null) {
                int i = start;
                while (i <= end) {
                    IndexedRegion r = model.getIndexedRegion(i);
                    if (r != null && !overlappingIndexedRegions.contains(r)) {
                        overlappingIndexedRegions.add(r);
                    }
                    ++i;
                }
                model.releaseFromRead();
            }
            return Arrays.asList(overlappingIndexedRegions.toArray());
        }

        private void createPartitionTabContents(SashForm sash) {
            Object[] objectArray;
            Composite partioningComposite = new Composite((Composite)sash, 0);
            partioningComposite.setLayout((Layout)new GridLayout(2, false));
            partioningComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(partioningComposite, 4);
            label.setText(SSEUIMessages.OffsetStatusLineContributionItem_8);
            label.setLayoutData((Object)new GridData(4, 4, false, false));
            final Combo partitioningCombo = new Combo(partioningComposite, 8);
            partitioningCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            final Label partitionerInstanceLabel = new Label(partioningComposite, 4);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalSpan = 2;
            partitionerInstanceLabel.setLayoutData((Object)gd);
            final TableViewer fPartitionTable = new TableViewer(partioningComposite, 65536);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 2;
            fPartitionTable.getControl().setLayoutData((Object)gd);
            fPartitionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            fPartitionTable.getTable().setHeaderVisible(true);
            fPartitionTable.getTable().setLinesVisible(true);
            String[] columns = new String[]{SSEUIMessages.OffsetStatusLineContributionItem_9, SSEUIMessages.OffsetStatusLineContributionItem_10, SSEUIMessages.OffsetStatusLineContributionItem_11};
            fPartitionTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    ITypedRegion partition = (ITypedRegion)element;
                    String text = null;
                    switch (columnIndex) {
                        case 0: {
                            text = Integer.toString(partition.getOffset());
                            break;
                        }
                        case 1: {
                            text = Integer.toString(partition.getLength());
                            break;
                        }
                        case 2: {
                            text = partition.getType();
                        }
                    }
                    if (text == null) {
                        text = "";
                    }
                    return text;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            TableLayout tlayout = new TableLayout();
            CellEditor[] cellEditors = new CellEditor[columns.length];
            int[] columnWidths = new int[]{Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 14, Display.getCurrent().getBounds().width / 5};
            int i = 0;
            while (i < columns.length) {
                tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
                TableColumn tc = new TableColumn(fPartitionTable.getTable(), 0);
                tc.setText(columns[i]);
                tc.setResizable(true);
                tc.setWidth(columnWidths[i]);
                ++i;
            }
            fPartitionTable.setCellEditors(cellEditors);
            fPartitionTable.setColumnProperties(columns);
            if (this.fDocument instanceof IDocumentExtension3) {
                objectArray = ((IDocumentExtension3)this.fDocument).getPartitionings();
            } else {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = "__dftl_partitioning";
            }
            Object[] partitionings = objectArray;
            partitioningCombo.setItems((String[])partitionings);
            partitioningCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection sel = ((InformationDialog)InformationDialog.this).OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
                    ITextSelection textSelection = (ITextSelection)sel;
                    try {
                        String partitionerText = InformationDialog.this.fDocument instanceof IDocumentExtension3 ? ((IDocumentExtension3)InformationDialog.this.fDocument).getDocumentPartitioner(partitioningCombo.getItem(partitioningCombo.getSelectionIndex())).toString() : "" + InformationDialog.this.fDocument.getDocumentPartitioner();
                        partitionerInstanceLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_13) + partitionerText);
                        fPartitionTable.setInput((Object)TextUtilities.computePartitioning((IDocument)InformationDialog.this.fDocument, (String)partitioningCombo.getItem(partitioningCombo.getSelectionIndex()), (int)textSelection.getOffset(), (int)textSelection.getLength(), (boolean)true));
                    }
                    catch (BadLocationException badLocationException) {
                        fPartitionTable.setInput((Object)new ITypedRegion[0]);
                    }
                }
            });
            try {
                if (partitionings.length > 0) {
                    String selectedPartitioning = partitioningCombo.getItem(0);
                    if (Utilities.contains((Object[])partitionings, (Object)"org.eclipse.wst.sse.core.default_structured_text_partitioning")) {
                        selectedPartitioning = "org.eclipse.wst.sse.core.default_structured_text_partitioning";
                        int i2 = 0;
                        while (i2 < partitionings.length) {
                            if (((String)partitionings[i2]).equals("org.eclipse.wst.sse.core.default_structured_text_partitioning")) {
                                partitioningCombo.select(i2);
                            }
                            ++i2;
                        }
                    } else {
                        partitioningCombo.select(0);
                    }
                    ISelection sel = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
                    ITextSelection textSelection = (ITextSelection)sel;
                    ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)selectedPartitioning, (int)textSelection.getOffset(), (int)textSelection.getLength(), (boolean)true);
                    fPartitionTable.setInput((Object)partitions);
                    String partitionerText = this.fDocument instanceof IDocumentExtension3 ? ((IDocumentExtension3)this.fDocument).getDocumentPartitioner(partitioningCombo.getItem(partitioningCombo.getSelectionIndex())).toString() : "" + this.fDocument.getDocumentPartitioner();
                    partitionerInstanceLabel.setText(String.valueOf(SSEUIMessages.OffsetStatusLineContributionItem_13) + partitionerText);
                } else {
                    ISelection sel = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
                    ITextSelection textSelection = (ITextSelection)sel;
                    fPartitionTable.setInput((Object)this.fDocument.computePartitioning(textSelection.getOffset(), textSelection.getLength()));
                }
            }
            catch (BadLocationException badLocationException) {
                fPartitionTable.setInput((Object)new ITypedRegion[0]);
            }
            partitioningCombo.setFocus();
            final StyledText text = new StyledText((Composite)sash, 10);
            fPartitionTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        IRegion partition = (IRegion)((IStructuredSelection)event.getSelection()).getFirstElement();
                        IDocument document = ((InformationDialog)InformationDialog.this).OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getDocument((Object)((InformationDialog)InformationDialog.this).OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput());
                        try {
                            String source = document.get(partition.getOffset(), partition.getLength());
                            text.setEnabled(true);
                            text.setText(source);
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            text.setEnabled(false);
        }

        private Composite createRegionTabContents(SashForm sashForm) {
            ISelection sel = OffsetStatusLineContributionItem.this.fTextEditor.getSelectionProvider().getSelection();
            ITextSelection textSelection = (ITextSelection)sel;
            final ArrayList<IStructuredDocumentRegion> documentRegions = new ArrayList<IStructuredDocumentRegion>();
            if (this.fDocument instanceof IStructuredDocument) {
                IStructuredDocument structuredDocument = (IStructuredDocument)this.fDocument;
                int pos = textSelection.getOffset();
                int end = textSelection.getOffset() + textSelection.getLength();
                IStructuredDocumentRegion docRegion = structuredDocument.getRegionAtCharacterOffset(pos);
                IStructuredDocumentRegion endRegion = structuredDocument.getRegionAtCharacterOffset(end);
                if (pos < end) {
                    while (docRegion != endRegion) {
                        documentRegions.add(docRegion);
                        docRegion = docRegion.getNext();
                    }
                }
                documentRegions.add(docRegion);
            }
            TreeViewer tree = new TreeViewer((Composite)sashForm, 768);
            final String START = SSEUIMessages.OffsetStatusLineContributionItem_15;
            final String LENGTH = SSEUIMessages.OffsetStatusLineContributionItem_16;
            final String TEXTLENGTH = SSEUIMessages.OffsetStatusLineContributionItem_17;
            final String CONTEXT = SSEUIMessages.OffsetStatusLineContributionItem_18;
            tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void dispose() {
                }

                public Object[] getChildren(Object parentElement) {
                    ArrayList<Object> children = new ArrayList<Object>(0);
                    if (parentElement instanceof ITextSelection) {
                        children.addAll(documentRegions);
                    }
                    if (parentElement instanceof ITextRegionCollection) {
                        children.add(((ITextRegionCollection)parentElement).getRegions().toArray());
                    }
                    if (parentElement instanceof ITextRegion) {
                        children.add(new KeyValuePair(CONTEXT, ((ITextRegion)parentElement).getType()));
                        children.add(new KeyValuePair(START, Integer.toString(((ITextRegion)parentElement).getStart())));
                        children.add(new KeyValuePair(TEXTLENGTH, Integer.toString(((ITextRegion)parentElement).getTextLength())));
                        children.add(new KeyValuePair(LENGTH, Integer.toString(((ITextRegion)parentElement).getLength())));
                    }
                    if (parentElement instanceof ITextRegionList) {
                        children.add(Arrays.asList(((ITextRegionList)parentElement).toArray()));
                    }
                    if (parentElement instanceof Collection) {
                        children.addAll((Collection)parentElement);
                    }
                    if (parentElement instanceof Object[]) {
                        children.addAll(Arrays.asList((Object[])parentElement));
                    }
                    return children.toArray();
                }

                public Object[] getElements(Object inputElement) {
                    return documentRegions.toArray();
                }

                public Object getParent(Object element) {
                    if (element instanceof IStructuredDocumentRegion) {
                        return ((IStructuredDocumentRegion)element).getParentDocument();
                    }
                    if (element instanceof ITextRegionContainer) {
                        return ((ITextRegionContainer)element).getParent();
                    }
                    return InformationDialog.this.fDocument;
                }

                public boolean hasChildren(Object element) {
                    return !(element instanceof KeyValuePair);
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            tree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof KeyValuePair) {
                        return String.valueOf(((KeyValuePair)element).fKey.toString().toLowerCase()) + ": " + ((KeyValuePair)element).fValue;
                    }
                    if (element instanceof IStructuredDocumentRegion) {
                        IStructuredDocumentRegion documentRegion = (IStructuredDocumentRegion)element;
                        int packageNameLength = documentRegion.getClass().getPackage().getName().length();
                        if (packageNameLength > 0) {
                            ++packageNameLength;
                        }
                        String name = documentRegion.getClass().getName().substring(packageNameLength);
                        String text = "[" + documentRegion.getStartOffset() + "-" + documentRegion.getEndOffset() + "] " + name + "@" + element.hashCode() + " " + documentRegion.getType();
                        return text;
                    }
                    if (element instanceof ITextRegion) {
                        ITextRegion textRegion = (ITextRegion)element;
                        int packageNameLength = textRegion.getClass().getPackage().getName().length();
                        if (packageNameLength > 0) {
                            ++packageNameLength;
                        }
                        String name = textRegion.getClass().getName().substring(packageNameLength);
                        String text = "[" + textRegion.getStart() + "-" + textRegion.getEnd() + "] " + name + "@" + element.hashCode() + " " + textRegion.getType();
                        return text;
                    }
                    return super.getText(element);
                }
            });
            tree.setInput((Object)this.fDocument);
            final Text displayText = new Text((Composite)sashForm, 2824);
            displayText.setBackground(sashForm.getDisplay().getSystemColor(25));
            tree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (o instanceof KeyValuePair) {
                            displayText.setText(((KeyValuePair)o).fValue.toString());
                        } else if (o instanceof ITextSelection) {
                            ITextSelection text = (ITextSelection)o;
                            try {
                                displayText.setText(InformationDialog.this.fDocument.get(text.getOffset(), text.getLength()));
                            }
                            catch (BadLocationException badLocationException) {
                                displayText.setText("");
                            }
                        } else if (o instanceof ITextRegionCollection) {
                            ITextRegionCollection region = (ITextRegionCollection)o;
                            displayText.setText(region.getFullText());
                        } else {
                            displayText.setText("" + o);
                        }
                    }
                }
            });
            return sashForm;
        }

        private void fillSelectionTabContents(Composite area, List selection, String description) {
            area.setLayout((Layout)new GridLayout());
            area.setLayoutData((Object)new GridData());
            Label typeName = new Label(area, 64);
            typeName.setLayoutData((Object)new GridData(4, 4, true, false));
            typeName.setText(description);
            new Label(area, 0).setLayoutData((Object)new GridData(4, 4, false, false));
            SashForm structuredSashForm = new SashForm(area, 0);
            structuredSashForm.setLayoutData((Object)new GridData(4, 4, true, true));
            structuredSashForm.setOrientation(512);
            final TableViewer structuredSelectionTable = new TableViewer((Composite)structuredSashForm, 68356);
            structuredSelectionTable.getTable().setHeaderVisible(true);
            structuredSelectionTable.getTable().setLinesVisible(true);
            structuredSelectionTable.setComparator(new ViewerComparator(){

                public int category(Object element) {
                    if (element instanceof IndexedRegion) {
                        return ((IndexedRegion)element).getStartOffset();
                    }
                    return super.category(element);
                }
            });
            structuredSelectionTable.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    if (element instanceof INodeNotifier) {
                        INodeAdapter adapterFor = ((INodeNotifier)element).getAdapterFor(IJFaceNodeAdapter.class);
                        if (columnIndex == 2 && adapterFor != null && adapterFor instanceof IJFaceNodeAdapter) {
                            IJFaceNodeAdapter adapter = (IJFaceNodeAdapter)adapterFor;
                            return adapter.getLabelImage(element);
                        }
                    }
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    String text = null;
                    if (element != null) {
                        switch (columnIndex) {
                            case 0: {
                                text = String.valueOf(((List)structuredSelectionTable.getInput()).indexOf(element));
                                break;
                            }
                            case 1: {
                                text = element.getClass().getName();
                                break;
                            }
                            case 2: {
                                text = StringUtils.firstLine((String)element.toString(), (int)999, (boolean)true);
                                break;
                            }
                            default: {
                                text = "";
                            }
                        }
                    }
                    return text;
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            TableLayout tlayout = new TableLayout();
            tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, true));
            tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(28, true));
            tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
            structuredSelectionTable.getTable().setLayout((Layout)tlayout);
            TableColumn tc = new TableColumn(structuredSelectionTable.getTable(), 0);
            tc.setText("Item");
            tc.setResizable(true);
            tc.setWidth(40);
            tc = new TableColumn(structuredSelectionTable.getTable(), 0);
            tc.setText("Class");
            tc.setResizable(true);
            tc.setWidth(40);
            tc = new TableColumn(structuredSelectionTable.getTable(), 0);
            tc.setText("Value");
            tc.setResizable(true);
            tc.setWidth(40);
            structuredSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            List input = selection;
            structuredSelectionTable.setInput((Object)input);
            final TreeViewer infoTree = new TreeViewer((Composite)structuredSashForm, 2816);
            infoTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    INodeAdapter adapterFor;
                    if (element instanceof TreeViewer && infoTree.getInput() instanceof INodeNotifier && (adapterFor = ((INodeNotifier)infoTree.getInput()).getAdapterFor(IJFaceNodeAdapter.class)) != null && adapterFor instanceof IJFaceNodeAdapter) {
                        IJFaceNodeAdapter adapter = (IJFaceNodeAdapter)adapterFor;
                        return adapter.getLabelImage(infoTree.getInput());
                    }
                    return super.getImage(element);
                }

                public String getText(Object element) {
                    IJFaceNodeAdapter adapter;
                    if (element instanceof Class) {
                        return "Class: " + ((Class)element).getName();
                    }
                    if (element instanceof Collection) {
                        return "Registered Adapters:";
                    }
                    if (element instanceof IRegion) {
                        return "Indexed Region offset span: [" + ((IRegion)element).getOffset() + "-" + ((IRegion)element).getLength() + "]";
                    }
                    if (element instanceof TreeViewer && infoTree.getInput() instanceof INodeNotifier && (adapter = (IJFaceNodeAdapter)((INodeNotifier)infoTree.getInput()).getAdapterFor(IJFaceNodeAdapter.class)) != null) {
                        return adapter.getLabelText(infoTree.getInput());
                    }
                    return super.getText(element);
                }
            });
            infoTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void dispose() {
                }

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof Collection) {
                        return ((Collection)parentElement).toArray();
                    }
                    return new Object[0];
                }

                public Object[] getElements(Object inputElement) {
                    ArrayList<Object> elements = new ArrayList<Object>(4);
                    if (inputElement != null) {
                        if (inputElement instanceof INodeNotifier && ((INodeNotifier)inputElement).getAdapterFor(IJFaceNodeAdapter.class) != null) {
                            elements.add(infoTree);
                        }
                        elements.add(inputElement.getClass());
                        if (inputElement instanceof IndexedRegion) {
                            elements.add(new Region(((IndexedRegion)inputElement).getStartOffset(), ((IndexedRegion)inputElement).getEndOffset()));
                        }
                        if (inputElement instanceof INodeNotifier) {
                            elements.add(((INodeNotifier)inputElement).getAdapters());
                        }
                    }
                    return elements.toArray();
                }

                public Object getParent(Object element) {
                    return null;
                }

                public boolean hasChildren(Object element) {
                    return element instanceof Collection;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            structuredSelectionTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    int selectionIndex = structuredSelectionTable.getTable().getSelectionIndex();
                    if (selectionIndex != -1) {
                        infoTree.setInput(structuredSelectionTable.getElementAt(selectionIndex));
                    } else {
                        infoTree.setInput((Object)event.getSelectionProvider().getSelection());
                    }
                    infoTree.expandToLevel(2);
                }
            });
            structuredSashForm.setWeights(new int[]{3, 2});
        }

        private String getLineNumber(Annotation annotation) {
            int line = -1;
            if (annotation instanceof MarkerAnnotation) {
                line = MarkerUtilities.getLineNumber((IMarker)((MarkerAnnotation)annotation).getMarker());
            } else {
                IAnnotationModel annotationModel = OffsetStatusLineContributionItem.this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)OffsetStatusLineContributionItem.this.fTextEditor.getEditorInput());
                Position p = annotationModel.getPosition(annotation);
                if (p != null && !p.isDeleted()) {
                    try {
                        line = this.fDocument.getLineOfOffset(p.getOffset()) + 1;
                    }
                    catch (BadLocationException e) {
                        return e.getMessage();
                    }
                }
            }
            return Integer.toString(line);
        }
    }

    static class KeyValuePair {
        Object fKey;
        String fValue;

        public KeyValuePair(Object key, String value) {
            this.fKey = key;
            this.fValue = value;
        }
    }

    class ShowEditorInformationAction
    extends Action {
        public void run() {
            super.run();
            new InformationDialog(((Control)OffsetStatusLineContributionItem.this.fTextEditor.getAdapter(Control.class)).getShell()).open();
        }
    }
}

