/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XSDNamespaceConstraintCategory implements Enumerator
{
    ANY_LITERAL(0, "any", "any"),
    NOT_LITERAL(1, "not", "not"),
    SET_LITERAL(2, "set", "set");

    public static final int ANY = 0;
    public static final int NOT = 1;
    public static final int SET = 2;
    private static final XSDNamespaceConstraintCategory[] VALUES_ARRAY;
    public static final List<XSDNamespaceConstraintCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDNamespaceConstraintCategory[]{ANY_LITERAL, NOT_LITERAL, SET_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDNamespaceConstraintCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDNamespaceConstraintCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDNamespaceConstraintCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDNamespaceConstraintCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDNamespaceConstraintCategory get(int value) {
        switch (value) {
            case 0: {
                return ANY_LITERAL;
            }
            case 1: {
                return NOT_LITERAL;
            }
            case 2: {
                return SET_LITERAL;
            }
        }
        return null;
    }

    private XSDNamespaceConstraintCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

