/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.internal.deployables;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.FlattenParticipantModel;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.eclipse.wst.web.internal.deployables.IFlatDeployable;

public abstract class FlatComponentDeployable
extends ProjectModule
implements IFlatDeployable {
    public static final String FLATTEN_PARTICIPANTS = "org.eclipse.wst.web.deployables.flatten.participants";
    private static final String FLATTEN_PARTICIPANTS_DELIM = ",";
    protected IVirtualComponent component = null;
    protected List<IModuleResource> members = new ArrayList<IModuleResource>();
    private FlatVirtualComponent cacheFlattened = null;

    static {
        Platform.getAdapterManager().registerAdapters(new IAdapterFactory(){

            public Class[] getAdapterList() {
                return new Class[]{IVirtualComponent.class};
            }

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                IModule module;
                FlatComponentDeployable deployable;
                if (adaptableObject instanceof IModule && (deployable = (FlatComponentDeployable)(module = (IModule)adaptableObject).loadAdapter(FlatComponentDeployable.class, null)) != null) {
                    IVirtualComponent virtualComponent = deployable.getComponent();
                    return virtualComponent;
                }
                return null;
            }
        }, IModule.class);
    }

    public FlatComponentDeployable(IProject project) {
        this(project, ComponentCore.createComponent((IProject)project));
    }

    public FlatComponentDeployable(IProject project, IVirtualComponent aComponent) {
        super(project);
        this.component = aComponent;
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    public boolean shouldCache() {
        return false;
    }

    public void clearCache() {
        this.cacheFlattened = null;
    }

    protected IFlatVirtualComponent getFlatComponent() {
        if (!this.shouldCache() || this.cacheFlattened == null) {
            FlatVirtualComponent.FlatComponentTaskModel options = new FlatVirtualComponent.FlatComponentTaskModel();
            options.put((Object)"org.eclipse.wst.common.componentcore.export.participantList", Arrays.asList(this.getParticipants()));
            FlatVirtualComponent tmp = new FlatVirtualComponent(this.component, options);
            if (this.shouldCache()) {
                this.cacheFlattened = tmp;
            }
            return tmp;
        }
        return this.cacheFlattened;
    }

    @Override
    public IFlattenParticipant[] getParticipants() {
        String[] ids = this.getParticipantIds();
        return this.getFlattenParticipants(ids);
    }

    @Override
    public String[] getParticipantIds() {
        String participants = this.component.getMetaProperties().getProperty(FLATTEN_PARTICIPANTS);
        String[] split = participants == null ? this.getDefaultFlattenParticipantIDs() : participants.split(FLATTEN_PARTICIPANTS_DELIM);
        int i = 0;
        while (i < split.length) {
            split[i] = split[i].trim();
            ++i;
        }
        return split;
    }

    protected IFlattenParticipant[] getFlattenParticipants(String[] ids) {
        ArrayList<IFlattenParticipant> participants = new ArrayList<IFlattenParticipant>();
        int i = 0;
        while (i < ids.length) {
            IFlattenParticipant tmp = FlattenParticipantModel.getDefault().getParticipant(ids[i]);
            if (tmp != null) {
                participants.add(tmp);
            }
            ++i;
        }
        return participants.toArray(new IFlattenParticipant[participants.size()]);
    }

    @Override
    public void addFlattenParticipant(String id, int position) {
        String participants = this.component.getMetaProperties().getProperty(FLATTEN_PARTICIPANTS);
        String[] split = participants == null ? this.getDefaultFlattenParticipantIDs() : participants.split(FLATTEN_PARTICIPANTS_DELIM);
        ArrayList<String> asList = new ArrayList<String>();
        asList.addAll(Arrays.asList(split));
        if (!asList.contains(id)) {
            if (position < asList.size()) {
                asList.add(position, id);
            } else {
                asList.add(id);
            }
        }
        String asString = this.implode(asList.toArray(new String[asList.size()]), FLATTEN_PARTICIPANTS_DELIM);
        this.component.setMetaProperty(FLATTEN_PARTICIPANTS, asString);
    }

    private String implode(String[] array, String delim) {
        String retval;
        if (array.length == 0) {
            retval = "";
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append(array[0]);
            int i = 1;
            while (i < array.length) {
                sb.append(delim);
                sb.append(array[i]);
                ++i;
            }
            retval = sb.toString();
        }
        return retval;
    }

    @Override
    public void removeFlattenParticipant(String id) {
        String participants = this.component.getMetaProperties().getProperty(FLATTEN_PARTICIPANTS);
        String[] split = participants == null ? this.getDefaultFlattenParticipantIDs() : participants.split(FLATTEN_PARTICIPANTS_DELIM);
        ArrayList<String> asList = new ArrayList<String>();
        asList.addAll(Arrays.asList(split));
        asList.remove(id);
        String asString = this.implode(asList.toArray(new String[asList.size()]), FLATTEN_PARTICIPANTS_DELIM);
        this.component.setMetaProperty(FLATTEN_PARTICIPANTS, asString);
    }

    @Override
    public String[] getDefaultFlattenParticipantIDs() {
        return new String[0];
    }

    public boolean isBinary() {
        return this.component == null ? false : this.component.isBinary();
    }

    public IModuleResource[] members() throws CoreException {
        if (this.component.isBinary()) {
            return this.LEGACY_binaryMembers();
        }
        IFlatVirtualComponent em = this.getFlatComponent();
        IFlatResource[] resources = em.fetchResources();
        return FlatComponentDeployable.convert(resources);
    }

    protected IModuleResource[] LEGACY_binaryMembers() {
        IFile ifile = (IFile)this.component.getAdapter(IFile.class);
        File file = (File)this.component.getAdapter(File.class);
        ModuleFile mf = ifile != null ? new ModuleFile(ifile, ifile.getName(), (IPath)new Path("")) : new ModuleFile(file, file.getName(), (IPath)new Path(""));
        return new IModuleResource[]{mf};
    }

    public IModule[] getChildModules() {
        return this.getModules();
    }

    public IChildModuleReference[] getExportModelChildren() throws CoreException {
        IFlatVirtualComponent em = this.getFlatComponent();
        IChildModuleReference[] children = em.getChildModules();
        return children;
    }

    public IModule[] getModules() {
        if (this.component.isBinary()) {
            return new IModule[0];
        }
        try {
            ArrayList<IModule> modules = new ArrayList<IModule>();
            IChildModuleReference[] children = this.getExportModelChildren();
            int i = 0;
            while (i < children.length) {
                IModule child = this.gatherModuleReference(this.component, children[i]);
                if (child != null) {
                    modules.add(child);
                }
                ++i;
            }
            return modules.toArray(new IModule[modules.size()]);
        }
        catch (CoreException coreException) {
            return new IModule[0];
        }
    }

    public String getPath(IModule m) {
        return this.getURI(m);
    }

    public String getURI(IModule module) {
        ProjectModule md = (ProjectModule)module.loadAdapter(ProjectModule.class, (IProgressMonitor)new NullProgressMonitor());
        if (md == this) {
            return VirtualReferenceUtilities.INSTANCE.getDefaultProjectArchiveName(this.component);
        }
        try {
            FlatComponentDeployable cd = (FlatComponentDeployable)module.loadAdapter(FlatComponentDeployable.class, (IProgressMonitor)new NullProgressMonitor());
            if (cd != null) {
                IFlatVirtualComponent em = this.getFlatComponent();
                IChildModuleReference[] children = em.getChildModules();
                int i = 0;
                while (i < children.length) {
                    IModule child = this.gatherModuleReference(this.component, children[i]);
                    if (child != null && child.getId().equals(module.getId())) {
                        return children[i].getRelativeURI().toString();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected IModule gatherModuleReference(IVirtualComponent component, IChildModuleReference child) {
        IVirtualComponent targetComponent = child.getComponent();
        if (targetComponent != null && targetComponent.getProject() != component.getProject() && !targetComponent.isBinary()) {
            return this.filterModuleDelegates(ServerUtil.getModules((IProject)targetComponent.getProject()));
        }
        return null;
    }

    protected IModule filterModuleDelegates(IModule[] modules) {
        int i = 0;
        while (i < modules.length) {
            ModuleDelegate md = (ModuleDelegate)modules[i].loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (md instanceof ProjectModule) {
                return modules[i];
            }
            ++i;
        }
        return modules.length > 0 ? modules[0] : null;
    }

    protected static IModuleResource[] convert(IFlatResource[] resources) {
        ArrayList<ComponentModuleResource> list = new ArrayList<ComponentModuleResource>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFlatFile) {
                list.add(new ComponentModuleFile(resources[i]));
            } else if (resources[i] instanceof IFlatFolder) {
                list.add(new ComponentModuleFolder(resources[i]));
            }
            ++i;
        }
        return list.toArray(new IModuleResource[list.size()]);
    }

    protected static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    public static class ComponentModuleFile
    extends ComponentModuleResource
    implements IModuleFile {
        public ComponentModuleFile(IFlatResource resource) {
            super(resource);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IModuleFile)) {
                return false;
            }
            IModuleFile mf = (IModuleFile)obj;
            if (!this.getName().equals(mf.getName())) {
                return false;
            }
            return this.getModuleRelativePath().equals((Object)mf.getModuleRelativePath());
        }

        public int hashCode() {
            return this.getName().hashCode() * 37 + this.getModuleRelativePath().hashCode();
        }
    }

    public static class ComponentModuleFolder
    extends ComponentModuleResource
    implements IModuleFolder {
        public ComponentModuleFolder(IFlatResource resource) {
            super(resource);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IModuleFolder)) {
                return false;
            }
            IModuleFolder mf = (IModuleFolder)obj;
            if (!this.getName().equals(mf.getName())) {
                return false;
            }
            return this.getModuleRelativePath().equals((Object)mf.getModuleRelativePath());
        }

        public int hashCode() {
            return this.getName().hashCode() * 37 + this.getModuleRelativePath().hashCode();
        }
    }

    public static class ComponentModuleResource {
        protected IFlatResource delegate;

        public ComponentModuleResource(IFlatResource resource) {
            this.delegate = resource;
        }

        public long getModificationStamp() {
            return ((IFlatFile)this.delegate).getModificationStamp();
        }

        public IPath getModuleRelativePath() {
            return this.delegate.getModuleRelativePath();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Object getAdapter(Class adapter) {
            return this.delegate.getAdapter(adapter);
        }

        public IModuleResource[] members() {
            IFlatResource[] children = ((IFlatFolder)this.delegate).members();
            return FlatComponentDeployable.convert(children);
        }

        public String toString() {
            return this.getName();
        }
    }
}

