/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.internal.emfworkbench.edit.EditModelExtension;

class EditModelExtensionRegistry
extends RegistryReader {
    private static EditModelExtensionRegistry INSTANCE = null;
    public static final String EDIT_MODEL_EXT_ELEMENT = "editModelExtension";
    public static final String EDIT_MODEL_ID_ATTR = "editModelID";
    public static final String GROUP_ID_ATTR = "functionGroupID";
    private Map extensions = null;

    protected EditModelExtensionRegistry() {
        super("org.eclipse.wst.common.emfworkbench.integration", EDIT_MODEL_EXT_ELEMENT);
    }

    public static EditModelExtensionRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EditModelExtensionRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        boolean result = false;
        ArrayList<EditModelExtension> extensionsByID = null;
        EditModelExtension editModelExtension = null;
        if (element.getName().equals(EDIT_MODEL_EXT_ELEMENT)) {
            editModelExtension = new EditModelExtension(element);
            extensionsByID = (ArrayList<EditModelExtension>)this.getExtensions().get(editModelExtension.getEditModelID());
            if (extensionsByID == null) {
                extensionsByID = new ArrayList<EditModelExtension>();
                this.getExtensions().put(editModelExtension.getEditModelID(), extensionsByID);
            }
            extensionsByID.add(editModelExtension);
            result = true;
        }
        return result;
    }

    protected Map getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashMap();
        }
        return this.extensions;
    }

    public Collection getEditModelResources(Object editModelID) {
        ArrayList editModelResources = new ArrayList();
        Collection editModelExtensions = (Collection)this.getExtensions().get(editModelID);
        if (editModelExtensions == null || editModelExtensions.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        for (EditModelExtension ext : editModelExtensions) {
            editModelResources.addAll(ext.getResources());
        }
        return !editModelExtensions.isEmpty() ? editModelResources : Collections.EMPTY_LIST;
    }
}

