/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.derived;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.s.derived.AbstractDerivedResourceHandler;
import org.eclipse.scout.sdk.core.s.derived.IDerivedResourceInput;
import org.eclipse.scout.sdk.core.s.dto.DtoGeneratorFactory;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.java.annotation.DataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.java.annotation.FormDataAnnotationDescriptor;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutInterfaceApi;

public class DtoUpdateHandler
extends AbstractDerivedResourceHandler {
    public DtoUpdateHandler(IDerivedResourceInput input) {
        super(input);
    }

    @Override
    protected Collection<? extends IFuture<?>> execute(IEnvironment env, IProgress progress) {
        return this.getInput().getSourceType(env).flatMap(sourceType -> this.writeDerivedTypeOf((IType)sourceType, env, progress)).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    protected Optional<IFuture<IType>> writeDerivedTypeOf(IType modelType, IEnvironment env, IProgress progress) {
        IScoutApi scoutApi = (IScoutApi)modelType.javaEnvironment().requireApi(IScoutApi.class);
        Optional<FormDataAnnotationDescriptor> formDataAnnotation = DtoUpdateHandler.findDataAnnotationForFormData(modelType);
        if (formDataAnnotation.isPresent()) {
            return this.getInput().getSourceFolderOf(formDataAnnotation.orElseThrow().getFormDataType(), env).flatMap(derivedSourceFolder -> DtoGeneratorFactory.createFormDataGenerator(modelType, derivedSourceFolder.javaEnvironment(), (FormDataAnnotationDescriptor)formDataAnnotation.orElseThrow()).map(g -> env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)g, (IClasspathEntry)derivedSourceFolder, progress)));
        }
        Optional<DataAnnotationDescriptor> pageDataAnnotation = DtoUpdateHandler.findDataAnnotationForPageData(modelType, scoutApi);
        if (pageDataAnnotation.isPresent()) {
            return this.getInput().getSourceFolderOf(pageDataAnnotation.orElseThrow().getDataType(), env).flatMap(derivedSourceFolder -> DtoGeneratorFactory.createPageDataGenerator(modelType, derivedSourceFolder.javaEnvironment(), (DataAnnotationDescriptor)pageDataAnnotation.orElseThrow()).map(g -> env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)g, (IClasspathEntry)derivedSourceFolder, progress)));
        }
        Optional<DataAnnotationDescriptor> dataAnnotation = DtoUpdateHandler.findDataAnnotationForRowData(modelType, scoutApi);
        return dataAnnotation.flatMap(dataAnnotationDescriptor -> this.getInput().getSourceFolderOf(dataAnnotationDescriptor.getDataType(), env).flatMap(derivedSourceFolder -> DtoGeneratorFactory.createTableRowDataGenerator(modelType, derivedSourceFolder.javaEnvironment(), dataAnnotationDescriptor).map(g -> env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)g, (IClasspathEntry)derivedSourceFolder, progress))));
    }

    protected static Optional<FormDataAnnotationDescriptor> findDataAnnotationForFormData(IType model) {
        return Optional.of(model).map(FormDataAnnotationDescriptor::of).filter(FormDataAnnotationDescriptor::isCreate).filter(d -> d.getFormDataType() != null);
    }

    protected static Optional<DataAnnotationDescriptor> findDataAnnotationForPageData(IType model, IScoutInterfaceApi api) {
        return Optional.of(model).filter(m -> m.isInstanceOf((ITypeNameSupplier)api.IPageWithTable())).flatMap(DataAnnotationDescriptor::of);
    }

    protected static Optional<DataAnnotationDescriptor> findDataAnnotationForRowData(IType model, IScoutInterfaceApi api) {
        if (model.isInstanceOf((ITypeNameSupplier)api.IColumn()) || model.isInstanceOf((ITypeNameSupplier)api.ITableExtension())) {
            return DataAnnotationDescriptor.of(model);
        }
        return Optional.of(model).filter(m -> m.isInstanceOf((ITypeNameSupplier)api.IPageWithTableExtension())).filter(m -> DtoUpdateHandler.containsTableExtension(m, api)).flatMap(DataAnnotationDescriptor::of);
    }

    protected static boolean containsTableExtension(IType model, IScoutInterfaceApi api) {
        return ((HierarchyInnerTypeQuery)model.innerTypes().withInstanceOf((ITypeNameSupplier)api.ITableExtension())).existsAny();
    }

    public String toString() {
        return "Update DTO for '" + this.getInput() + "'.";
    }
}

