/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.form;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.form.HandlerMethodBodyGenerator;
import org.eclipse.scout.sdk.core.s.java.annotation.FormDataAnnotation;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.ScoutMethodGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class FormGenerator<TYPE extends FormGenerator<TYPE>>
extends PrimaryTypeGenerator<TYPE> {
    public static final String SERVICE_LOAD_METHOD_NAME = "load";
    public static final String SERVICE_STORE_METHOD_NAME = "store";
    public static final String MODIFY_HANDLER_NAME = "ModifyHandler";
    public static final String SERVICE_PREPARE_CREATE_METHOD_NAME = "prepareCreate";
    public static final String SERVICE_CREATE_METHOD_NAME = "create";
    public static final String NEW_HANDLER_NAME = "NewHandler";
    private final AtomicInteger m_nextFieldGetterSortCode = new AtomicInteger(200);
    private String m_formData;
    private String m_serviceIfc;
    private String m_updatePermission;
    private String m_createPermission;
    private List<String> m_formFields;

    protected void setup() {
        ITypeGenerator<ITypeGenerator<?>> mainBox = this.createMainBox();
        ((FormGenerator)((FormGenerator)((FormGenerator)((FormGenerator)((FormGenerator)this.withAnnotation(this.formData().map(dto -> ScoutAnnotationGenerator.createFormData(dto, FormDataAnnotation.SdkCommand.CREATE, null)).orElse(null))).withAnnotation(FormGenerator.classIdGenerator(this.fullyQualifiedName()))).withMethod(this.createGetConfiguredTitle(), new Object[]{100})).withType(mainBox, new Object[]{2000})).withType(this.createHandler(NEW_HANDLER_NAME), new Object[]{5000})).withType(this.createHandler(MODIFY_HANDLER_NAME), new Object[]{6000});
        this.withFieldGetter(mainBox.fullyQualifiedName());
        this.appendGroupBox(mainBox);
        this.appendButtons(mainBox);
        IMethodGenerator<?, ?> startModify = this.createStartMethod("startModify", MODIFY_HANDLER_NAME);
        IMethodGenerator<?, ?> startNew = this.createStartMethod("startNew", NEW_HANDLER_NAME);
        if (startModify != null) {
            this.withMethod(startModify, new Object[]{3000});
        }
        if (startNew != null) {
            this.withMethod(startNew, new Object[]{4000});
        }
    }

    protected IMethodGenerator<?, ?> createGetConfiguredTitle() {
        CharSequence nlsKeyName = Strings.capitalize((CharSequence)Strings.removeSuffix((String)((String)this.elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"Form has no name.", (Object[])new Object[0]))), (CharSequence)"Form"));
        return ScoutMethodGenerator.createNlsMethodFrom(IScoutApi.class, api -> api.AbstractForm().getConfiguredTitleMethodName(), nlsKeyName);
    }

    protected IMethodGenerator<?, ?> createStartMethod(String methodName, String handlerSimpleName) {
        String modifyHandlerFqn = this.fullyQualifiedName() + "$" + handlerSimpleName;
        return ((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asPublic()).withElementName(methodName)).withReturnType("void").withBody(b -> {
            if (MODIFY_HANDLER_NAME.equals(handlerSimpleName)) {
                b.appendFrom(IScoutApi.class, api -> api.AbstractForm().startInternalExclusiveMethodName());
            } else {
                b.appendFrom(IScoutApi.class, api -> api.AbstractForm().startInternalMethodName());
            }
            ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.parenthesisOpen()).appendNew((CharSequence)modifyHandlerFqn)).parenthesisClose()).parenthesisClose()).semicolon();
        });
    }

    protected ITypeGenerator<? extends ITypeGenerator<?>> createMainBox() {
        return ((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).withAnnotation(ScoutAnnotationGenerator.createOrder(1000.0))).withAnnotation(FormGenerator.classIdGenerator(this.fullyQualifiedName()))).withElementName("MainBox")).withSuperClassFrom(IScoutApi.class, api -> api.AbstractGroupBox().fqn()).setDeclaringFullyQualifiedName(this.fullyQualifiedName());
    }

    protected void appendGroupBox(ITypeGenerator<?> parent) {
        ITypeGenerator<ITypeGenerator<?>> groupBox = this.createGroupBox(parent.fullyQualifiedName());
        parent.withType(groupBox, new Object[]{100});
        this.withFieldGetter(groupBox.fullyQualifiedName());
        AtomicInteger index = new AtomicInteger(1);
        Strings.capitalize(this.formFields()).forEach(formField -> this.appendFormField((CharSequence)formField, groupBox, index.getAndIncrement() * 1000));
    }

    protected ITypeGenerator<? extends ITypeGenerator<?>> createGroupBox(String declaringFqn) {
        return ((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).withElementName("GroupBox")).withAnnotation(ScoutAnnotationGenerator.createOrder(1000.0))).withAnnotation(FormGenerator.classIdGenerator(this.fullyQualifiedName()))).withSuperClassFrom(IScoutApi.class, api -> api.AbstractGroupBox().fqn()).setDeclaringFullyQualifiedName(declaringFqn);
    }

    protected void appendFormField(CharSequence formField, ITypeGenerator<?> parent, double order) {
        ITypeGenerator<ITypeGenerator<?>> field = this.createFormField(formField, parent.fullyQualifiedName(), order);
        parent.withType(field, new Object[0]);
        this.withFieldGetter(field.fullyQualifiedName());
    }

    protected ITypeGenerator<? extends ITypeGenerator<?>> createFormField(CharSequence formField, String declaringFqn, double order) {
        return ((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).withElementName(formField + "Field")).withSuperClassFrom(IScoutApi.class, api -> api.AbstractStringField().fqn()).withAnnotation(ScoutAnnotationGenerator.createOrder(order))).withAnnotation(FormGenerator.classIdGenerator(this.fullyQualifiedName()))).withMethod(ScoutMethodGenerator.createNlsMethodFrom(IScoutApi.class, api -> api.AbstractFormField().getConfiguredLabelMethodName(), formField), new Object[0]).withMethod(ScoutMethodGenerator.createGetConfiguredMandatory(true), new Object[0]).withMethod(ScoutMethodGenerator.createGetConfiguredMaxLength(60), new Object[0]).setDeclaringFullyQualifiedName(declaringFqn);
    }

    protected void appendButtons(ITypeGenerator<?> parent) {
        ITypeGenerator<ITypeGenerator<?>> okButton = this.createOkButton(parent.fullyQualifiedName(), 2000.0);
        ITypeGenerator<ITypeGenerator<?>> cancelButton = this.createCancelButton(parent.fullyQualifiedName(), 3000.0);
        parent.withType(okButton, new Object[]{200}).withType(cancelButton, new Object[]{300});
        this.withFieldGetter(okButton.fullyQualifiedName());
        this.withFieldGetter(cancelButton.fullyQualifiedName());
    }

    protected ITypeGenerator<? extends ITypeGenerator<?>> createOkButton(String declaringFqn, double order) {
        return this.createButtonFrom("OkButton", declaringFqn, IScoutApi.class, api -> api.AbstractOkButton().fqn(), order);
    }

    protected ITypeGenerator<? extends ITypeGenerator<?>> createCancelButton(String declaringFqn, double order) {
        return this.createButtonFrom("CancelButton", declaringFqn, IScoutApi.class, api -> api.AbstractCancelButton().fqn(), order);
    }

    protected <API extends IApiSpecification> ITypeGenerator<? extends ITypeGenerator<?>> createButtonFrom(String buttonName, String declaringFqn, Class<API> apiDefinition, Function<API, String> superClassSupplier, double order) {
        return ((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).withElementName(buttonName)).withAnnotation(ScoutAnnotationGenerator.createOrder(order))).withAnnotation(FormGenerator.classIdGenerator(this.fullyQualifiedName()))).withSuperClassFrom(apiDefinition, superClassSupplier).setDeclaringFullyQualifiedName(declaringFqn);
    }

    protected ITypeGenerator<? extends ITypeGenerator<?>> createHandler(String name) {
        boolean isModify = MODIFY_HANDLER_NAME.equals(name);
        return ((ITypeGenerator)((ITypeGenerator)TypeGenerator.create().asPublic()).withElementName(name)).withSuperClassFrom(IScoutApi.class, api -> api.AbstractFormHandler().fqn()).withMethod((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asProtected()).withReturnType("void").withElementNameFrom(IScoutApi.class, api -> api.AbstractFormHandler().execLoadMethodName())).withBody(b -> this.createHandlerMethodBody((IMethodBodyBuilder<?>)b, isModify, true)).withAnnotation(AnnotationGenerator.createOverride()), new Object[0]).withMethod((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asProtected()).withReturnType("void").withElementNameFrom(IScoutApi.class, api -> api.AbstractFormHandler().execStoreMethodName())).withBody(b -> this.createHandlerMethodBody((IMethodBodyBuilder<?>)b, isModify, false)).withAnnotation(AnnotationGenerator.createOverride()), new Object[0]);
    }

    protected void createHandlerMethodBody(IMethodBodyBuilder<?> b, boolean isModify, boolean isLoad) {
        this.createHandlerMethodBodyGenerator(isModify, isLoad).generate(b);
    }

    protected HandlerMethodBodyGenerator createHandlerMethodBodyGenerator(boolean isModify, boolean isLoad) {
        HandlerMethodBodyGenerator handlerMethodBodyGenerator = new HandlerMethodBodyGenerator(isModify).withFormDataType(this.formData().orElse(null)).withServiceInterface(this.serviceInterface().orElse(null));
        if (isModify) {
            return handlerMethodBodyGenerator.withPermission(this.permissionUpdate().orElse(null));
        }
        return handlerMethodBodyGenerator.withPermission(this.permissionCreate().orElse(null));
    }

    protected static IAnnotationGenerator<?> classIdGenerator(String fqn) {
        return Strings.notBlank((CharSequence)ClassIds.nextIfEnabled(fqn)).map(ScoutAnnotationGenerator::createClassId).orElse(null);
    }

    protected void withFieldGetter(String fqn) {
        this.withMethod(ScoutMethodGenerator.createFieldGetter(fqn), new Object[]{this.getNextFieldGetterSortCode()});
    }

    protected int getNextFieldGetterSortCode() {
        return this.m_nextFieldGetterSortCode.getAndAdd(10);
    }

    public Optional<String> formData() {
        return Strings.notBlank((CharSequence)this.m_formData);
    }

    public TYPE withFormData(String formData) {
        this.m_formData = formData;
        return (TYPE)((Object)((FormGenerator)this.thisInstance()));
    }

    public Optional<String> serviceInterface() {
        return Strings.notBlank((CharSequence)this.m_serviceIfc);
    }

    public TYPE withServiceInterface(String serviceIfc) {
        this.m_serviceIfc = serviceIfc;
        return (TYPE)((Object)((FormGenerator)this.thisInstance()));
    }

    public Optional<String> permissionUpdate() {
        return Strings.notBlank((CharSequence)this.m_updatePermission);
    }

    public TYPE withPermissionUpdate(String updatePermission) {
        this.m_updatePermission = updatePermission;
        return (TYPE)((Object)((FormGenerator)this.thisInstance()));
    }

    public Optional<String> permissionCreate() {
        return Strings.notBlank((CharSequence)this.m_createPermission);
    }

    public TYPE withPermissionCreate(String createPermission) {
        this.m_createPermission = createPermission;
        return (TYPE)((Object)((FormGenerator)this.thisInstance()));
    }

    public List<String> formFields() {
        return this.m_formFields;
    }

    public TYPE withFormFields(List<String> formFields) {
        this.m_formFields = formFields;
        return (TYPE)((Object)((FormGenerator)this.thisInstance()));
    }
}

