/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.java.generator.method;

import java.util.Set;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.expression.ExpressionBuilder;
import org.eclipse.scout.sdk.core.java.builder.expression.IExpressionBuilder;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutVariousApi;
import org.eclipse.scout.sdk.core.s.java.builder.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.java.builder.body.ScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.java.generator.method.IScoutMethodGenerator;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ScoutMethodGenerator<TYPE extends IScoutMethodGenerator<TYPE, BODY>, BODY extends IScoutMethodBodyBuilder<?>>
extends MethodGenerator<TYPE, BODY>
implements IScoutMethodGenerator<TYPE, BODY> {
    protected ScoutMethodGenerator() {
    }

    protected ScoutMethodGenerator(IMethod method, IWorkingCopyTransformer transformer) {
        super(method, transformer);
    }

    public static IScoutMethodGenerator<?, ?> create(IMethod method, IWorkingCopyTransformer transformer) {
        return new ScoutMethodGenerator(method, transformer);
    }

    public static IScoutMethodGenerator<?, ?> create() {
        return new ScoutMethodGenerator();
    }

    protected BODY createMethodBodyBuilder(ISourceBuilder<?> inner) {
        return (BODY)ScoutMethodBodyBuilder.create(inner, this);
    }

    public static IScoutMethodGenerator<?, ?> createFieldGetter(String fieldFqn) {
        String dotBasedFqn = ((String)Ensure.notBlank((CharSequence)fieldFqn)).replace('$', '.');
        String fieldSimpleName = JavaTypes.simpleName((CharSequence)dotBasedFqn);
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().asPublic()).withElementName("get" + Strings.capitalize((CharSequence)fieldSimpleName))).withReturnType(fieldFqn)).withBody(b -> ((IScoutMethodBodyBuilder)b.returnClause()).appendGetFieldByClass(fieldFqn).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createNlsMethod(String methodName, CharSequence nlsKeyName) {
        return ScoutMethodGenerator.createNlsMethodFrom(null, api -> methodName, nlsKeyName);
    }

    public static <API extends IApiSpecification> IScoutMethodGenerator<?, ?> createNlsMethodFrom(Class<API> api, Function<API, String> methodFunction, CharSequence nlsKeyName) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).asProtected()).withElementNameFrom(api, methodFunction)).withReturnType(String.class.getName())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.appendTodo("verify translation")).returnClause()).refClassFrom(IScoutApi.class, IScoutVariousApi::TEXTS)).dot()).appendFrom(IScoutApi.class, a -> a.TEXTS().getMethodName())).parenthesisOpen()).stringLiteral(nlsKeyName)).parenthesisClose()).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredDisplayable(boolean displayable) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).withElementNameFrom(IScoutApi.class, api -> api.AbstractColumn().getConfiguredDisplayableMethodName())).asProtected()).withReturnType("boolean")).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).append(displayable)).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredPrimaryKey(boolean primaryKey) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).withElementNameFrom(IScoutApi.class, api -> api.AbstractColumn().getConfiguredPrimaryKeyMethodName())).asProtected()).withReturnType("boolean")).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).append(primaryKey)).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredWidth(int width) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).asProtected()).withReturnType("int")).withElementNameFrom(IScoutApi.class, api -> api.AbstractColumn().getConfiguredWidthMethodName())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).append(width)).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredMenuTypes(ISourceGenerator<IExpressionBuilder<?>> menuTypes) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).withElementNameFrom(IScoutApi.class, api -> api.AbstractMenu().getConfiguredMenuTypesMethodName())).asProtected()).withReturnTypeFrom(IScoutApi.class, api -> Set.class.getName() + '<' + '?' + ' ' + "extends" + ' ' + api.IMenuType().fqn() + '>')).withBody(b -> {
            ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).refClassFrom(IScoutApi.class, IScoutVariousApi::CollectionUtility)).dot()).appendFrom(IScoutApi.class, api -> api.CollectionUtility().hashSetMethodName())).parenthesisOpen();
            if (menuTypes != null) {
                b.append(menuTypes.generalize(ExpressionBuilder::create));
            }
            ((IScoutMethodBodyBuilder)b.parenthesisClose()).semicolon();
        });
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredMandatory(boolean mandatory) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).withElementNameFrom(IScoutApi.class, api -> api.AbstractFormField().getConfiguredMandatoryMethodName())).asProtected()).withReturnType("boolean")).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).append(mandatory)).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredMaxLength(int maxLength) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).asProtected()).withReturnType("int")).withElementNameFrom(IScoutApi.class, api -> api.AbstractStringField().getConfiguredMaxLengthMethodName())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).append(maxLength)).semicolon());
    }

    public static IScoutMethodGenerator<?, ?> createGetConfiguredService(CharSequence serviceIfc, String keyType) {
        return (IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)((IScoutMethodGenerator)ScoutMethodGenerator.create().withAnnotation(AnnotationGenerator.createOverride())).asProtected()).withReturnTypeFrom(IScoutApi.class, api -> Class.class.getName() + '<' + '?' + ' ' + "extends" + ' ' + api.ILookupService().fqn() + '<' + keyType + '>' + '>')).withElementNameFrom(IScoutApi.class, api -> api.LookupCall().getConfiguredServiceMethodName())).withBody(b -> ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)b.returnClause()).classLiteral(serviceIfc)).semicolon());
    }
}

