/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.lookupcall;

import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.PrimaryTypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.classid.ClassIds;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.lookupcall.LookupCallGenerator;
import org.eclipse.scout.sdk.core.s.testcase.TestGenerator;
import org.eclipse.scout.sdk.core.s.util.ITier;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class LookupCallNewOperation
implements BiConsumer<IEnvironment, IProgress> {
    private String m_lookupCallName;
    private IClasspathEntry m_sharedSourceFolder;
    private IClasspathEntry m_serverSourceFolder;
    private IClasspathEntry m_testSourceFolder;
    private String m_package;
    private String m_superType;
    private String m_keyType;
    private String m_lookupServiceSuperType;
    private String m_serverSession;
    private IFuture<IType> m_createdLookupCall;
    private String m_createdLookupCallFqn;
    private IFuture<IType> m_createdLookupServiceIfc;
    private String m_createdLookupServiceIfcFqn;
    private IFuture<IType> m_createdLookupServiceImpl;
    private String m_createdLookupServiceImplFqn;
    private IFuture<IType> m_createdLookupCallTest;
    private String m_createdLookupCallTestFqn;

    @Override
    public void accept(IEnvironment env, IProgress progress) {
        this.validateOperation();
        this.prepareProgress(progress);
        this.executeOperation(env, progress);
    }

    protected void validateOperation() {
        Ensure.notBlank((CharSequence)this.getLookupCallName(), (CharSequence)"No lookup call name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSharedSourceFolder(), (CharSequence)"No shared source folder provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getKeyType(), (CharSequence)"No key type provided", (Object[])new Object[0]);
        Ensure.notBlank((CharSequence)this.getPackage(), (CharSequence)"No package name provided", (Object[])new Object[0]);
        Ensure.notNull((Object)this.getSuperType(), (CharSequence)"No supertype provided", (Object[])new Object[0]);
    }

    protected void prepareProgress(IProgress progress) {
        progress.init(this.getTotalWork(), this.toString(), new Object[0]);
    }

    protected void executeOperation(IEnvironment env, IProgress progress) {
        String svcName = Strings.removeSuffix((String)this.getLookupCallName(), (CharSequence)"Call") + "Service";
        this.setCreatedLookupServiceIfc(this.createLookupServiceIfc(svcName, env, progress.newChild(1)));
        if (this.getServerSourceFolder() != null && this.getLookupServiceSuperType() != null) {
            String serverPackage = ScoutTier.Shared.convert(ScoutTier.Server, this.getPackage());
            this.setCreatedLookupServiceImpl(this.createLookupServiceImpl(svcName, serverPackage, env, progress.newChild(1)));
        }
        progress.setWorkRemaining(2);
        this.setCreatedLookupCall(this.createLookupCall(env, progress.newChild(1)));
        this.setCreatedLookupCallTest(this.createLookupCallTest(env, progress.newChild(1)));
    }

    protected int getTotalWork() {
        return 4;
    }

    protected IFuture<IType> createLookupCallTest(IEnvironment env, IProgress progress) {
        IClasspathEntry testSourceFolder = this.getTestSourceFolder();
        if (testSourceFolder == null) {
            return null;
        }
        IJavaEnvironment testEnv = testSourceFolder.javaEnvironment();
        IScoutApi scoutApi = (IScoutApi)testEnv.requireApi(IScoutApi.class);
        ITier<?> targetTier = ITier.of(testEnv).orElseThrow(() -> Ensure.newFail((CharSequence)"Test-source-folder {} has no access to Scout classes", (Object[])new Object[]{testSourceFolder}));
        String testPackage = ScoutTier.Shared.convert(targetTier, this.getPackage());
        boolean isClient = ScoutTier.Client.isIncludedIn(targetTier);
        String runnerFqn = isClient ? scoutApi.ClientTestRunner().fqn() : scoutApi.ServerTestRunner().fqn();
        if (!testEnv.exists(runnerFqn)) {
            SdkLog.warning((CharSequence)"Cannot generate a LookupCall test class because the class '{}' is not on the classpath. Consider adding the required dependency.", (Object[])new Object[]{runnerFqn});
            return null;
        }
        String createLookupCallMethodName = "createLookupCall";
        TestGenerator lookupCallTestBuilder = (TestGenerator)((TestGenerator)((TestGenerator)((TestGenerator)((TestGenerator)((Object)((TestGenerator)((TestGenerator)new TestGenerator().withElementName(this.getLookupCallName() + "Test")).withPackageName(testPackage)).asClientTest(isClient))).withRunner(runnerFqn).withMethod(((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().asProtected()).withElementName(createLookupCallMethodName)).withReturnType(this.getCreatedLookupCallFqn()).withBody(b -> ((IMethodBodyBuilder)((IMethodBodyBuilder)b.returnClause().appendNew((CharSequence)this.getCreatedLookupCallFqn())).parenthesisClose()).semicolon()), new Object[0])).withMethod(this.createTestMethod(createLookupCallMethodName, scoutApi.LookupCall().getDataByAllMethodName()), new Object[0])).withMethod(this.createTestMethod(createLookupCallMethodName, scoutApi.LookupCall().getDataByKeyMethodName()), new Object[0])).withMethod(this.createTestMethod(createLookupCallMethodName, scoutApi.LookupCall().getDataByTextMethodName()), new Object[0]);
        if (!isClient && Strings.hasText((CharSequence)this.getServerSession())) {
            lookupCallTestBuilder.withSession(this.getServerSession());
        }
        this.setCreatedLookupCallTestFqn(lookupCallTestBuilder.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)lookupCallTestBuilder, testSourceFolder, progress);
    }

    protected IMethodGenerator<?, ?> createTestMethod(String createLookupCallMethodName, String getDataByMethodName) {
        return ((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)MethodGenerator.create().withAnnotation(ScoutAnnotationGenerator.createTest())).asPublic()).withReturnType("void").withElementName("test" + Strings.capitalize((CharSequence)getDataByMethodName))).withBody(b -> {
            String callVarName = "call";
            IScoutApi scoutApi = (IScoutApi)b.context().requireApi(IScoutApi.class);
            String dataType = List.class.getName() + '<' + "? extends " + scoutApi.ILookupRow().fqn() + '<' + this.getKeyType() + '>' + '>';
            ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.ref((CharSequence)this.getCreatedLookupCallFqn())).space()).append(callVarName)).equalSign()).append(createLookupCallMethodName)).parenthesisOpen()).parenthesisClose()).semicolon()).nl()).appendTodo((CharSequence)"fill call")).ref((CharSequence)dataType)).space()).append("data")).equalSign()).append(callVarName)).dot()).append(getDataByMethodName)).parenthesisOpen()).parenthesisClose()).semicolon()).nl()).appendTodo((CharSequence)"verify data");
        });
    }

    protected IFuture<IType> createLookupServiceIfc(String svcName, IEnvironment env, IProgress progress) {
        String ifcName = "I" + svcName;
        IScoutApi scoutApi = (IScoutApi)this.getSharedSourceFolder().javaEnvironment().requireApi(IScoutApi.class);
        StringBuilder superTypeBuilder = new StringBuilder(scoutApi.ILookupService().fqn());
        superTypeBuilder.append('<');
        superTypeBuilder.append(this.getKeyType());
        superTypeBuilder.append('>');
        PrimaryTypeGenerator ifc = PrimaryTypeGenerator.create().withAnnotation(ScoutAnnotationGenerator.createTunnelToServer()).withElementName(ifcName).withPackageName(this.getPackage()).asPublic().asInterface().withComment(IJavaElementCommentBuilder::appendDefaultElementComment).withInterface(superTypeBuilder.toString());
        this.setCreatedLookupServiceIfcFqn(ifc.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)ifc, this.getSharedSourceFolder(), progress);
    }

    protected IFuture<IType> createLookupServiceImpl(String svcName, String serverPackage, IEnvironment env, IProgress progress) {
        PrimaryTypeGenerator impl = this.createLookupServiceImplGenerator().withElementName(svcName).withPackageName(serverPackage);
        this.setCreatedLookupServiceImplFqn(impl.fullyQualifiedName());
        this.getCreatedLookupServiceIfc().result();
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)impl, this.getServerSourceFolder(), progress);
    }

    protected PrimaryTypeGenerator<?> createLookupServiceImplGenerator() {
        StringBuilder superTypeBuilder = new StringBuilder(this.getLookupServiceSuperType());
        superTypeBuilder.append('<');
        superTypeBuilder.append(this.getKeyType());
        superTypeBuilder.append('>');
        return PrimaryTypeGenerator.create().asPublic().withSuperClass(superTypeBuilder.toString()).withInterface(this.getCreatedLookupServiceIfcFqn()).withAllMethodsImplemented();
    }

    protected IFuture<IType> createLookupCall(IEnvironment env, IProgress progress) {
        Object lcsb = ((LookupCallGenerator)((Object)((LookupCallGenerator)((Object)((LookupCallGenerator)((LookupCallGenerator)this.createLookupCallGenerator().withElementName(this.getLookupCallName())).withPackageName(this.getPackage())).withSuperType(this.getSuperType()))).withKeyType(this.getKeyType()))).withClassIdValue(ClassIds.nextIfEnabled(this.getPackage() + "." + this.getLookupCallName()));
        if (this.getCreatedLookupServiceIfc() != null) {
            ((LookupCallGenerator)((Object)lcsb)).withLookupServiceInterface(this.getCreatedLookupServiceIfcFqn());
        }
        this.setCreatedLookupCallFqn(lcsb.fullyQualifiedName());
        return env.writeCompilationUnitAsync((ICompilationUnitGenerator<?>)lcsb, this.getSharedSourceFolder(), progress);
    }

    protected LookupCallGenerator<?> createLookupCallGenerator() {
        return (LookupCallGenerator)new LookupCallGenerator().withAllMethodsImplemented();
    }

    public IFuture<IType> getCreatedLookupCall() {
        return this.m_createdLookupCall;
    }

    protected void setCreatedLookupCall(IFuture<IType> createdLookupCall) {
        this.m_createdLookupCall = createdLookupCall;
    }

    public String getCreatedLookupCallFqn() {
        return this.m_createdLookupCallFqn;
    }

    protected void setCreatedLookupCallFqn(String createdLookupCallFqn) {
        this.m_createdLookupCallFqn = createdLookupCallFqn;
    }

    public String getLookupCallName() {
        return this.m_lookupCallName;
    }

    public void setLookupCallName(String lookupCallName) {
        this.m_lookupCallName = lookupCallName;
    }

    public IClasspathEntry getSharedSourceFolder() {
        return this.m_sharedSourceFolder;
    }

    public void setSharedSourceFolder(IClasspathEntry sharedSourceFolder) {
        this.m_sharedSourceFolder = sharedSourceFolder;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String package1) {
        this.m_package = package1;
    }

    public String getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(String superType) {
        this.m_superType = superType;
    }

    public String getKeyType() {
        return this.m_keyType;
    }

    public void setKeyType(String keyType) {
        this.m_keyType = keyType;
    }

    public IClasspathEntry getServerSourceFolder() {
        return this.m_serverSourceFolder;
    }

    public void setServerSourceFolder(IClasspathEntry serverSourceFolder) {
        this.m_serverSourceFolder = serverSourceFolder;
    }

    public IFuture<IType> getCreatedLookupServiceIfc() {
        return this.m_createdLookupServiceIfc;
    }

    protected void setCreatedLookupServiceIfc(IFuture<IType> createdLookupServiceIfc) {
        this.m_createdLookupServiceIfc = createdLookupServiceIfc;
    }

    public String getCreatedLookupServiceIfcFqn() {
        return this.m_createdLookupServiceIfcFqn;
    }

    protected void setCreatedLookupServiceIfcFqn(String createdLookupServiceIfcFqn) {
        this.m_createdLookupServiceIfcFqn = createdLookupServiceIfcFqn;
    }

    public IFuture<IType> getCreatedLookupServiceImpl() {
        return this.m_createdLookupServiceImpl;
    }

    protected void setCreatedLookupServiceImpl(IFuture<IType> createdLookupServiceImpl) {
        this.m_createdLookupServiceImpl = createdLookupServiceImpl;
    }

    public String getCreatedLookupServiceImplFqn() {
        return this.m_createdLookupServiceImplFqn;
    }

    protected void setCreatedLookupServiceImplFqn(String createdLookupServiceImplFqn) {
        this.m_createdLookupServiceImplFqn = createdLookupServiceImplFqn;
    }

    public String getLookupServiceSuperType() {
        return this.m_lookupServiceSuperType;
    }

    public void setLookupServiceSuperType(String lookupServiceSuperType) {
        this.m_lookupServiceSuperType = lookupServiceSuperType;
    }

    public IClasspathEntry getTestSourceFolder() {
        return this.m_testSourceFolder;
    }

    public void setTestSourceFolder(IClasspathEntry testSourceFolder) {
        this.m_testSourceFolder = testSourceFolder;
    }

    public IFuture<IType> getCreatedLookupCallTest() {
        return this.m_createdLookupCallTest;
    }

    protected void setCreatedLookupCallTest(IFuture<IType> createdLookupCallTest) {
        this.m_createdLookupCallTest = createdLookupCallTest;
    }

    public String getCreatedLookupCallTestFqn() {
        return this.m_createdLookupCallTestFqn;
    }

    protected void setCreatedLookupCallTestFqn(String createdLookupCallTestFqn) {
        this.m_createdLookupCallTestFqn = createdLookupCallTestFqn;
    }

    public String getServerSession() {
        return this.m_serverSession;
    }

    public void setServerSession(String serverSession) {
        this.m_serverSession = serverSession;
    }

    public String toString() {
        return "Create new Lookup Call";
    }
}

