/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.prop;

import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.PropertyDataTypeDetector;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.s.model.js.objects.ScoutJsObjectQuery;
import org.eclipse.scout.sdk.core.s.model.js.prop.IScoutJsPropertyValue;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsBooleanPropertyValue;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsObjectPropertyValue;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertyType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class ScoutJsProperty {
    private final FinalValue<ScoutJsPropertyType> m_type;
    private final PropertyDataTypeDetector m_detector;
    private final IScoutJsObject m_scoutJsObject;
    private final IField m_field;

    protected ScoutJsProperty(IScoutJsObject scoutJsObject, IField field, PropertyDataTypeDetector dataTypeDetector) {
        this.m_scoutJsObject = (IScoutJsObject)Ensure.notNull((Object)scoutJsObject);
        this.m_field = (IField)Ensure.notNull((Object)field);
        this.m_type = new FinalValue();
        this.m_detector = dataTypeDetector;
        if (dataTypeDetector != null) {
            dataTypeDetector.markUsed(this.field().name());
        }
    }

    protected ScoutJsProperty(IScoutJsObject scoutJsObject, IField field) {
        this.m_scoutJsObject = (IScoutJsObject)Ensure.notNull((Object)scoutJsObject);
        this.m_field = (IField)Ensure.notNull((Object)field);
        this.m_type = new FinalValue();
        this.m_type.set((Object)new ScoutJsPropertyType(field.dataType().orElse(null), this));
        this.m_detector = null;
    }

    public IField field() {
        return this.m_field;
    }

    public IScoutJsObject scoutJsObject() {
        return this.m_scoutJsObject;
    }

    public ScoutJsPropertyType type() {
        return (ScoutJsPropertyType)this.m_type.computeIfAbsentAndGet(this::detectType);
    }

    protected ScoutJsPropertyType detectType() {
        return this.m_detector.detect(this);
    }

    public String name() {
        return this.field().name();
    }

    public boolean isObjectType() {
        return "objectType".equals(this.name());
    }

    public static ScoutJsProperty choose(ScoutJsProperty higher, ScoutJsProperty lower) {
        if (lower == null) {
            return higher;
        }
        if (lower.type().dataType().isEmpty() && higher.type().dataType().isPresent()) {
            return higher;
        }
        return lower;
    }

    public Stream<? extends IScoutJsPropertyValue> computePossibleValues(ScoutJsModel scope) {
        ScoutJsPropertyType type = this.type();
        if (type.isBoolean()) {
            return Stream.of(true, false).map(v -> new ScoutJsBooleanPropertyValue((boolean)v, this));
        }
        if (type.isEnumLike()) {
            return type.scoutJsEnums().flatMap(scoutJsEnum -> scoutJsEnum.createPropertyValues(this));
        }
        return ((ScoutJsObjectQuery)((Object)scope.findScoutObjects().withoutModifier(Modifier.ABSTRACT).withIncludeDependencies(true))).stream().filter(o -> !o.declaringClass().isInterface()).filter(o -> o.scoutJsModel() == scope || o.declaringClass().isExportedFromModule()).filter(o -> type.isAssignableFrom((IDataType)o.declaringClass())).map(o -> new ScoutJsObjectPropertyValue((IScoutJsObject)o, this));
    }

    public String toString() {
        return this.name() + " [type=" + this.type() + ", object=" + this.scoutJsObject() + "]";
    }
}

