/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.prop;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsCoreConstants;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.IPropertyDataTypeOverride;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.PropertyDataTypeDetector;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.util.Strings;

public final class ScoutJsPropertyFactory {
    private ScoutJsPropertyFactory() {
    }

    public static Map<String, ScoutJsProperty> createProperties(Stream<IField> properties, List<IPropertyDataTypeOverride> overrides, IScoutJsObject owner) {
        PropertyDataTypeDetector datatypeDetector = new PropertyDataTypeDetector(overrides);
        Set<String> excludedProperties = ScoutJsPropertyFactory.getExcludedProperties((INodeElement)owner.declaringClass());
        Stream<IField> fields = properties.filter(f -> !ScoutJsPropertyFactory.isPrivateOrJQueryLike(f));
        if (!excludedProperties.isEmpty()) {
            fields = fields.filter(f -> !excludedProperties.contains(f.name()));
        }
        LinkedHashMap result = fields.map(f -> new ScoutJsProperty(owner, (IField)f, datatypeDetector)).collect(Collectors.toMap(ScoutJsProperty::name, Function.identity(), (a, b) -> {
            SdkLog.warning((CharSequence)"Duplicate property '{}' in '{}'.", (Object[])new Object[]{b.name(), owner});
            return b;
        }, LinkedHashMap::new));
        datatypeDetector.unused().forEach((name, type) -> {
            if (!excludedProperties.contains(name)) {
                result.compute(name, (key, lower) -> ScoutJsProperty.choose(ScoutJsPropertyFactory.createSynthetic(owner, key, type), lower));
            }
            SdkLog.warning((CharSequence)"Property {}.{} is declared as {} property but is not declared as field.", (Object[])new Object[]{owner.name(), name, type});
        });
        return Collections.unmodifiableMap(result);
    }

    private static ScoutJsProperty createSynthetic(IScoutJsObject owner, String propertyName, IDataType dataType) {
        IField syntheticField = owner.scoutJsModel().nodeModule().nodeElementFactory().createSyntheticField(propertyName, dataType, owner.declaringClass());
        return new ScoutJsProperty(owner, syntheticField);
    }

    private static Set<String> getExcludedProperties(INodeElement fieldDeclaringClass) {
        if ("@eclipse-scout/core".equals(fieldDeclaringClass.containingModule().name())) {
            return ScoutJsCoreConstants.getExcludedProperties(fieldDeclaringClass.name());
        }
        return Collections.emptySet();
    }

    private static boolean isPrivateOrJQueryLike(IField field) {
        String name = field.name();
        if (Strings.startsWith((CharSequence)name, (char)'$') || Strings.startsWith((CharSequence)name, (char)'_')) {
            return true;
        }
        String dataTypeName = field.dataType().map(INodeElement::name).orElse(null);
        return Strings.startsWith((String)dataTypeName, (String)"JQuery");
    }
}

