/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaUtils;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Translations;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public class UiTextContributor {
    private static final Pattern KEY_LITERAL_PAT = Pattern.compile("\"(" + ITranslation.KEY_REGEX.pattern() + ")\"");
    private static final Pattern TEXT_SERVICE_CLASS_LITERAL_PAT = Pattern.compile("([\\w.]+TextProviderService)\\.class");
    private final IType m_contributor;
    private final FinalValue<Set<String>> m_keys;

    public UiTextContributor(IType contributor) {
        this.m_contributor = (IType)Ensure.notNull((Object)contributor);
        this.m_keys = new FinalValue();
    }

    public IType type() {
        return this.m_contributor;
    }

    public Stream<String> keys() {
        return this.m_keys.opt().stream().flatMap(Collection::stream);
    }

    public boolean load(IProgress progress) {
        return this.m_keys.computeIfAbsent(() -> this.loadAllKeys(progress));
    }

    protected Set<String> loadAllKeys(IProgress progress) {
        return this.type().source().map(SourceRange::asCharSequence).map(JavaUtils::removeComments).flatMap(Strings::notBlank).map(src -> this.loadAllKeys((CharSequence)src, progress)).orElseGet(this::noKeysFound);
    }

    protected Set<String> noKeysFound() {
        SdkLog.warning((CharSequence)"Could not calculate available translation keys for '{}'. No source code available. Please ensure to enable Maven source download.", (Object[])new Object[]{this.type().name()});
        return Collections.emptySet();
    }

    protected Set<String> loadAllKeys(CharSequence methodSource, IProgress progress) {
        return Stream.concat(UiTextContributor.loadDirectLiterals(methodSource), this.loadReferencedTextProviderServices(methodSource, progress)).collect(Collectors.toUnmodifiableSet());
    }

    protected static Stream<String> loadDirectLiterals(CharSequence contributeUiTextKeysMethodSource) {
        return KEY_LITERAL_PAT.matcher(contributeUiTextKeysMethodSource).results().map(match -> match.group(1));
    }

    protected Stream<String> loadReferencedTextProviderServices(CharSequence contributeUiTextKeysMethodSource, IProgress progress) {
        IType contributor = this.type();
        IScoutApi scoutApi = (IScoutApi)contributor.javaEnvironment().requireApi(IScoutApi.class);
        List<IType> referencedTextServices = TEXT_SERVICE_CLASS_LITERAL_PAT.matcher(contributeUiTextKeysMethodSource).results().map(match -> match.group(1)).map(arg_0 -> ((IType)contributor).resolveSimpleName(arg_0)).flatMap(Optional::stream).filter(type -> type.isInstanceOf((ITypeNameSupplier)scoutApi.ITextProviderService())).toList();
        progress.init(referencedTextServices.size(), "Load referenced text provider service", new Object[0]);
        return referencedTextServices.stream().flatMap(txtService -> Translations.createStore(txtService, progress.newChild(1)).stream()).flatMap(ITranslationStore::keys);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(UiTextContributor.class.getSimpleName()).append(" [").append(this.type().name()).append(']');
        return builder.toString();
    }

    public int hashCode() {
        return this.type().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiTextContributor other = (UiTextContributor)obj;
        return this.type().equals(other.type());
    }
}

