/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.maven;

import java.util.Optional;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Pom {
    private Pom() {
    }

    public static Optional<String> artifactId(Document pom) {
        if (pom == null) {
            return Optional.empty();
        }
        return Xml.firstChildElement((Node)pom.getDocumentElement(), (String)"artifactId").map(Node::getTextContent).flatMap(Strings::notBlank);
    }

    public static Optional<String> groupId(Document pom) {
        return Pom.getInheritedValueOfPom(pom, "groupId");
    }

    public static Optional<String> version(Document pom) {
        return Pom.getInheritedValueOfPom(pom, "version");
    }

    public static Optional<String> parentArtifactId(Document pom) {
        if (pom == null) {
            return Optional.empty();
        }
        return Xml.firstChildElement((Node)pom.getDocumentElement(), (String)"parent").flatMap(parent -> Xml.firstChildElement((Node)parent, (String)"artifactId")).map(Node::getTextContent).flatMap(Strings::notBlank);
    }

    static Optional<String> getInheritedValueOfPom(Document pom, String tagName) {
        if (pom == null) {
            return Optional.empty();
        }
        Element documentElement = pom.getDocumentElement();
        Optional<String> directlySpecified = Xml.firstChildElement((Node)documentElement, (String)tagName).map(Node::getTextContent).filter(Strings::hasText);
        if (directlySpecified.isPresent()) {
            return directlySpecified;
        }
        return Xml.firstChildElement((Node)documentElement, (String)"parent").flatMap(parent -> Xml.firstChildElement((Node)parent, (String)tagName)).map(Node::getTextContent).flatMap(Strings::notBlank);
    }
}

