/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.util.Collection;
import java.util.Optional;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapUtils;
import org.eclipse.scout.sdk.core.s.widgetmap.ObjectType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.util.Ensure;

public class IdObjectType {
    private final String m_id;
    private final ObjectType m_objectType;

    protected IdObjectType(String id, ObjectType objectType) {
        this.m_id = (String)Ensure.notNull((Object)id);
        this.m_objectType = (ObjectType)Ensure.notNull((Object)objectType);
    }

    public static Optional<IdObjectType> create(String id, IES6Class es6Class, Collection<String> usedNames) {
        if (id == null) {
            return Optional.empty();
        }
        return ObjectType.create(es6Class, usedNames).map(e -> new IdObjectType(id, (ObjectType)e));
    }

    public static Optional<IdObjectType> create(IObjectLiteral objectLiteral, Collection<String> usedNames, ScoutJsModel scoutJsModel) {
        return Optional.ofNullable(objectLiteral).flatMap(ol -> IdObjectType.create(IdObjectTypeMapUtils.getId(ol, scoutJsModel).orElse(null), IdObjectTypeMapUtils.getObjectType(ol).orElse(null), usedNames));
    }

    public String id() {
        return this.m_id;
    }

    public ObjectType objectType() {
        return this.m_objectType;
    }
}

