/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.scout.sdk.core.java.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.internal.TypeImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationTypeWithEcj
extends AbstractTypeWithEcj {
    private final CompilationUnitSpi m_cu;
    private final DeclarationTypeWithEcj m_declaringType;
    private final TypeDeclaration m_astNode;
    private final List<TypeSpi> m_typeArguments;
    private final FinalValue<PackageSpi> m_package;
    private final FinalValue<String> m_fqn;
    private final FinalValue<String> m_elementName;
    private final FinalValue<TypeSpi> m_superType;
    private final FinalValue<List<TypeSpi>> m_memberTypes;
    private final FinalValue<List<TypeSpi>> m_superInterfaces;
    private final FinalValue<List<TypeParameterSpi>> m_typeParameters;
    private final FinalValue<List<DeclarationAnnotationWithEcj>> m_annotations;
    private final FinalValue<List<MethodSpi>> m_methods;
    private final FinalValue<List<FieldSpi>> m_fields;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_javaDocSource;
    private final FinalValue<SourceRange> m_staticInitSource;
    private int m_flags;

    protected DeclarationTypeWithEcj(AbstractJavaEnvironment env, CompilationUnitSpi cu, DeclarationTypeWithEcj declaringType, TypeDeclaration astNode) {
        super(env);
        this.m_cu = (CompilationUnitSpi)Ensure.notNull((Object)cu);
        this.m_declaringType = declaringType;
        this.m_astNode = (TypeDeclaration)Ensure.notNull((Object)astNode);
        this.m_typeArguments = Collections.emptyList();
        this.m_flags = -1;
        this.m_package = new FinalValue();
        this.m_fqn = new FinalValue();
        this.m_elementName = new FinalValue();
        this.m_superType = new FinalValue();
        this.m_memberTypes = new FinalValue();
        this.m_superInterfaces = new FinalValue();
        this.m_typeParameters = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_methods = new FinalValue();
        this.m_fields = new FinalValue();
        this.m_source = new FinalValue();
        this.m_javaDocSource = new FinalValue();
        this.m_staticInitSource = new FinalValue();
    }

    public TypeSpi internalFindNewElement() {
        TypeSpi newSpi = this.getJavaEnvironment().findType(this.getName());
        if (newSpi == null) {
            return null;
        }
        return newSpi.getCompilationUnit().getTypes().stream().filter(declType -> declType.getName().equals(this.getName())).findFirst().orElse(null);
    }

    @Override
    public TypeBinding getInternalBinding() {
        return null;
    }

    protected IType internalCreateApi() {
        return new TypeImplementor((TypeSpi)this);
    }

    public TypeDeclaration getInternalTypeDeclaration() {
        return this.m_astNode;
    }

    public int getArrayDimension() {
        return 0;
    }

    public TypeSpi getLeafComponentType() {
        return null;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isAnonymous() {
        return this.m_astNode.name == null || this.m_astNode.name.length < 1;
    }

    public String getName() {
        return (String)this.m_fqn.computeIfAbsentAndGet(() -> SpiWithEcjUtils.qualifiedNameOf(this.isAnonymous() ? CharOperation.NO_CHAR : this.m_astNode.binding.qualifiedPackageName(), this.m_astNode.binding.qualifiedSourceName()));
    }

    public String getElementName() {
        return (String)this.m_elementName.computeIfAbsentAndGet(() -> new String(this.m_astNode.name));
    }

    public PackageSpi getPackage() {
        return (PackageSpi)this.m_package.computeIfAbsentAndGet(() -> {
            char[] qualifiedPackageName = this.m_astNode.binding.qualifiedPackageName();
            if (qualifiedPackageName != null && qualifiedPackageName.length > 0) {
                return this.javaEnvWithEcj().createPackage(new String(qualifiedPackageName));
            }
            return this.javaEnvWithEcj().createDefaultPackage();
        });
    }

    public List<DeclarationAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createDeclarationAnnotations(this.javaEnvWithEcj(), (AnnotatableSpi)this, this.m_astNode.annotations));
    }

    public List<FieldSpi> getFields() {
        return (List)this.m_fields.computeIfAbsentAndGet(() -> {
            FieldDeclaration[] fields = this.m_astNode.fields;
            if (fields == null || fields.length < 1) {
                return Collections.emptyList();
            }
            return Arrays.stream(fields).map(fd -> this.javaEnvWithEcj().createDeclarationField(this, (FieldDeclaration)fd)).collect(Collectors.toList());
        });
    }

    public List<MethodSpi> getMethods() {
        return (List)this.m_methods.computeIfAbsentAndGet(() -> {
            AbstractMethodDeclaration[] methods = this.m_astNode.methods;
            if (methods == null || methods.length < 1) {
                return Collections.emptyList();
            }
            return Arrays.stream(methods).filter(a -> a.bodyStart > 0).filter(a -> !Arrays.equals(TypeConstants.INIT, a.selector)).map(a -> this.javaEnvWithEcj().createDeclarationMethod(this, (AbstractMethodDeclaration)a)).collect(Collectors.toList());
        });
    }

    public List<TypeSpi> getTypes() {
        return (List)this.m_memberTypes.computeIfAbsentAndGet(() -> {
            TypeDeclaration[] memberTypes = this.m_astNode.memberTypes;
            if (memberTypes == null || memberTypes.length < 1) {
                return Collections.emptyList();
            }
            return Arrays.stream(memberTypes).map(d -> this.javaEnvWithEcj().createDeclarationType(this.m_cu, this, (TypeDeclaration)d)).collect(Collectors.toList());
        });
    }

    protected static TypeBinding getSuperClassBinding(DeclarationTypeWithEcj decl) {
        if (decl.m_astNode.superclass == null) {
            return null;
        }
        return decl.m_astNode.superclass.resolvedType;
    }

    public TypeSpi getSuperClass() {
        return (TypeSpi)this.m_superType.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), DeclarationTypeWithEcj.getSuperClassBinding(this), () -> (TypeBinding)this.withNewElement(DeclarationTypeWithEcj::getSuperClassBinding)));
    }

    protected static TypeBinding[] getSuperInterfaceBindings(DeclarationTypeWithEcj d) {
        TypeReference[] interfaces = d.m_astNode.superInterfaces;
        if (interfaces == null) {
            return Binding.NO_TYPES;
        }
        return (TypeBinding[])Arrays.stream(interfaces).map(i -> i.resolvedType).filter(Objects::nonNull).toArray(TypeBinding[]::new);
    }

    public List<TypeSpi> getSuperInterfaces() {
        return (List)this.m_superInterfaces.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), DeclarationTypeWithEcj.getSuperInterfaceBindings(this), () -> (TypeBinding[])this.withNewElement(DeclarationTypeWithEcj::getSuperInterfaceBindings)));
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getTypeFlags(this.m_astNode.modifiers, (AllocationExpression)this.m_astNode.allocation, SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    public List<TypeSpi> getTypeArguments() {
        return this.m_typeArguments;
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return (List)this.m_typeParameters.computeIfAbsentAndGet(() -> SpiWithEcjUtils.toTypeParameterSpi(this.m_astNode.typeParameters, this, this.javaEnvWithEcj()));
    }

    public boolean hasTypeParameters() {
        TypeParameter[] typeParams = this.m_astNode.typeParameters;
        return typeParams != null && typeParams.length > 0;
    }

    public CompilationUnitSpi getCompilationUnit() {
        return this.m_cu;
    }

    public TypeSpi getDeclaringType() {
        return this.m_declaringType;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> this.javaEnvWithEcj().getSource(this.m_cu, this.m_astNode.declarationSourceStart, this.m_astNode.declarationSourceEnd));
    }

    public SourceRange getSourceOfStaticInitializer() {
        return (SourceRange)this.m_staticInitSource.computeIfAbsentAndGet(() -> {
            FieldDeclaration[] fields = this.m_astNode.fields;
            if (fields == null) {
                return null;
            }
            return Arrays.stream(fields).filter(fieldDecl -> fieldDecl.type == null && fieldDecl.name == null).findAny().map(fieldDecl -> this.javaEnvWithEcj().getSource(this.m_cu, fieldDecl.declarationSourceStart, fieldDecl.declarationSourceEnd)).orElse(null);
        });
    }

    public SourceRange getJavaDoc() {
        return (SourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createSourceRange((ASTNode)this.m_astNode.javadoc, this.m_cu, this.javaEnvWithEcj()));
    }

    public boolean isWildcardType() {
        return false;
    }
}

