/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Literal;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VoidTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingFieldWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingMethodWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingTypeParameterWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationMethodWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.metavalue.MetaValueFactory;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractSpiElement;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public final class SpiWithEcjUtils {
    private static final String DEPRECATED_ANNOTATION_FQN = Deprecated.class.getName();

    private SpiWithEcjUtils() {
    }

    static List<TypeParameterSpi> createTypeParameters(AbstractMemberWithEcj<?> owner, TypeVariableBinding[] typeParams) {
        if (typeParams == null || typeParams.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<TypeParameterSpi> result = new ArrayList<TypeParameterSpi>(typeParams.length);
        int index = 0;
        JavaEnvironmentWithEcj env = (JavaEnvironmentWithEcj)owner.getJavaEnvironment();
        for (TypeVariableBinding param : typeParams) {
            result.add(env.createBindingTypeParameter(owner, param, index));
            ++index;
        }
        return result;
    }

    static List<TypeSpi> bindingsToTypes(JavaEnvironmentWithEcj env, TypeBinding[] bindings, Supplier<TypeBinding[]> newElementLookupStrategy) {
        return SpiWithEcjUtils.bindingsToTypes(env, bindings, null, newElementLookupStrategy);
    }

    static List<TypeSpi> bindingsToTypes(JavaEnvironmentWithEcj env, TypeBinding[] bindings, TypeSpi declaringType, Supplier<TypeBinding[]> newElementLookupStrategy) {
        if (bindings == null || bindings.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.stream(bindings).map(binding -> SpiWithEcjUtils.bindingToType(env, binding, declaringType, () -> SpiWithEcjUtils.lambda$bindingsToTypes$0((Supplier)newElementLookupStrategy, binding))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static TypeBinding findBindingWithKey(TypeBinding[] newBindings, char[] key) {
        if (newBindings == null) {
            return null;
        }
        return Arrays.stream(newBindings).filter(b -> Strings.equals((char[])b.signableName(), (char[])key)).findAny().orElse(null);
    }

    static TypeSpi bindingToType(JavaEnvironmentWithEcj env, TypeBinding b, Supplier<? extends TypeBinding> newElementLookupStrategy) {
        return SpiWithEcjUtils.bindingToType(env, b, null, newElementLookupStrategy);
    }

    static TypeSpi bindingToType(JavaEnvironmentWithEcj env, TypeBinding b, TypeSpi declaringType, Supplier<? extends TypeBinding> newElementLookupStrategy) {
        return SpiWithEcjUtils.bindingToType(env, b, declaringType, false, newElementLookupStrategy);
    }

    static List<TypeParameterSpi> toTypeParameterSpi(TypeParameter[] typeParams, AbstractMemberWithEcj<?> method, JavaEnvironmentWithEcj env) {
        if (typeParams == null || typeParams.length < 1) {
            return Collections.emptyList();
        }
        return IntStream.range(0, typeParams.length).mapToObj(i -> env.createDeclarationTypeParameter(method, typeParams[i], i)).collect(Collectors.toList());
    }

    static SourceRange createSourceRange(ASTNode node, CompilationUnitSpi cu, JavaEnvironmentWithEcj env) {
        if (node == null) {
            return null;
        }
        if (cu == null) {
            return null;
        }
        return env.getSource(cu, node.sourceStart(), node.sourceEnd());
    }

    static AnnotationSpi findNewAnnotationIn(AnnotatableSpi owner, String typeName) {
        AnnotatableSpi newOwner = (AnnotatableSpi)((AbstractSpiElement)owner).internalFindNewElement();
        if (newOwner == null) {
            return null;
        }
        return newOwner.getAnnotations().stream().filter(a -> typeName.equals(a.getElementName())).findAny().orElse(null);
    }

    static AnnotationElementSpi findNewAnnotationElementIn(AnnotationSpi annotation, String name) {
        AnnotationSpi newDeclaringAnnotation = (AnnotationSpi)((AbstractSpiElement)annotation).internalFindNewElement();
        if (newDeclaringAnnotation == null) {
            return null;
        }
        return (AnnotationElementSpi)newDeclaringAnnotation.getValues().get(name);
    }

    static MethodSpi findNewMethodIn(TypeSpi declaringType, String methodId) {
        TypeSpi newType = (TypeSpi)((AbstractSpiElement)declaringType).internalFindNewElement();
        if (newType == null) {
            return null;
        }
        return newType.getMethods().stream().filter(newM -> methodId.equals(newM.getMethodId())).findFirst().orElse(null);
    }

    static String qualifiedNameOf(char[] pck, char[] sourceName) {
        int pckLen = pck.length;
        boolean hasPackage = pckLen > 0;
        int fqnLength = pckLen + sourceName.length;
        if (hasPackage) {
            ++fqnLength;
        }
        char[] fqn = new char[fqnLength];
        int nameInsertPos = 0;
        if (hasPackage) {
            System.arraycopy(pck, 0, fqn, 0, pckLen);
            fqn[pckLen] = 46;
            nameInsertPos = pckLen + 1;
        }
        System.arraycopy(sourceName, 0, fqn, nameInsertPos, sourceName.length);
        for (int i = nameInsertPos; i < fqn.length; ++i) {
            if (fqn[i] != '.') continue;
            fqn[i] = 36;
        }
        return new String(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TypeBinding resolveTypeOfArgument(AbstractVariableDeclaration argument, BlockScope scope, AbstractJavaEnvironment env) {
        TypeReference type = argument.type;
        TypeBinding result = type.resolvedType;
        if (result != null) {
            return result;
        }
        Object object = env.lock();
        synchronized (object) {
            type.resolveType(scope);
        }
        return type.resolvedType;
    }

    static TypeSpi bindingToType(JavaEnvironmentWithEcj env, TypeBinding b, TypeSpi declaringType, boolean isWildCard, Supplier<? extends TypeBinding> newElementLookupStrategy) {
        if (b == null) {
            return null;
        }
        if (b instanceof VoidTypeBinding) {
            return env.createVoidType();
        }
        if (b instanceof WildcardBinding) {
            WildcardBinding wb = (WildcardBinding)b;
            TypeBinding allBounds = wb.allBounds();
            if (allBounds == null) {
                return env.createWildcardOnlyType();
            }
            return SpiWithEcjUtils.bindingToType(env, allBounds, declaringType, true, newElementLookupStrategy);
        }
        if (b instanceof ReferenceBinding) {
            return env.createBindingType((ReferenceBinding)b, declaringType, isWildCard, () -> (ReferenceBinding)newElementLookupStrategy.get());
        }
        if (b instanceof BaseTypeBinding) {
            return env.createBindingBaseType((BaseTypeBinding)b);
        }
        if (b instanceof ArrayBinding) {
            return env.createBindingArrayType((ArrayBinding)b, isWildCard, () -> (ArrayBinding)newElementLookupStrategy.get());
        }
        throw new IllegalStateException("Unsupported binding type: " + b.getClass().getName());
    }

    static int getTypeFlags(int modifiers, AllocationExpression allocation, boolean hasDeprecatedAnnotation) {
        boolean isEnumInit;
        int currentModifiers = modifiers;
        boolean bl = isEnumInit = allocation != null && allocation.enumConstant != null;
        if (isEnumInit) {
            currentModifiers |= 0x4000;
        }
        boolean deprecated = hasDeprecatedAnnotation || (currentModifiers & 0x100000) != 0;
        currentModifiers &= 0xFFFF;
        if (deprecated) {
            currentModifiers |= 0x100000;
        }
        return currentModifiers & 0xFFFFFFDF;
    }

    static int getMethodFlags(int modifiers, boolean isVarargs, boolean isDeprecated) {
        int currentModifiers = modifiers & 0x11FFFF;
        if (isVarargs) {
            currentModifiers |= 0x80;
        }
        if (isDeprecated) {
            currentModifiers |= 0x100000;
        }
        return currentModifiers;
    }

    static TypeSpi declaringTypeOf(JavaElementSpi owner) {
        if (owner instanceof TypeSpi) {
            return (TypeSpi)owner;
        }
        if (owner instanceof MemberSpi) {
            return ((MemberSpi)owner).getDeclaringType();
        }
        if (owner instanceof TypeParameterSpi) {
            return SpiWithEcjUtils.declaringTypeOf((JavaElementSpi)((TypeParameterSpi)owner).getDeclaringMember());
        }
        if (owner instanceof MethodParameterSpi) {
            return ((MethodParameterSpi)owner).getDeclaringMethod().getDeclaringType();
        }
        if (owner instanceof AnnotationSpi) {
            return SpiWithEcjUtils.declaringTypeOf((JavaElementSpi)((AnnotationSpi)owner).getOwner());
        }
        if (owner instanceof AnnotationElementSpi) {
            return SpiWithEcjUtils.declaringTypeOf((JavaElementSpi)((AnnotationElementSpi)owner).getDeclaringAnnotation());
        }
        throw new SdkException((CharSequence)"Unknown owner type: {}", new Object[]{owner.getClass().getName()});
    }

    static Scope memberScopeOf(JavaElementSpi owner) {
        if (owner instanceof TypeSpi) {
            return SpiWithEcjUtils.classScopeOf(owner);
        }
        if (owner instanceof MethodSpi) {
            return SpiWithEcjUtils.methodScopeOf(owner);
        }
        if (owner instanceof TypeParameterSpi) {
            return SpiWithEcjUtils.memberScopeOf((JavaElementSpi)((TypeParameterSpi)owner).getDeclaringMember());
        }
        if (owner instanceof MethodParameterSpi) {
            return SpiWithEcjUtils.methodScopeOf((JavaElementSpi)((MethodParameterSpi)owner).getDeclaringMethod());
        }
        if (owner instanceof AnnotationSpi) {
            return SpiWithEcjUtils.memberScopeOf((JavaElementSpi)((AnnotationSpi)owner).getOwner());
        }
        throw new SdkException((CharSequence)"Unknown owner type: {}", new Object[]{owner.getClass().getName()});
    }

    static ClassScope classScopeOf(JavaElementSpi owner) {
        TypeBinding b;
        TypeSpi t = SpiWithEcjUtils.declaringTypeOf(owner);
        if (t instanceof DeclarationTypeWithEcj) {
            return ((DeclarationTypeWithEcj)t).getInternalTypeDeclaration().scope;
        }
        if (t instanceof AbstractTypeWithEcj && (b = ((AbstractTypeWithEcj)t).getInternalBinding()) instanceof SourceTypeBinding) {
            return ((SourceTypeBinding)b).scope;
        }
        return null;
    }

    static MethodScope methodScopeOf(JavaElementSpi owner) {
        if (owner instanceof BindingMethodWithEcj) {
            AbstractMethodDeclaration d = SpiWithEcjUtils.sourceMethodOf((BindingMethodWithEcj)owner);
            if (d != null) {
                return d.scope;
            }
        } else {
            if (owner instanceof DeclarationMethodWithEcj) {
                return ((DeclarationMethodWithEcj)owner).getInternalMethodDeclaration().scope;
            }
            if (owner instanceof TypeParameterSpi) {
                return SpiWithEcjUtils.methodScopeOf((JavaElementSpi)((TypeParameterSpi)owner).getDeclaringMember());
            }
            if (owner instanceof MethodParameterSpi) {
                return SpiWithEcjUtils.methodScopeOf((JavaElementSpi)((MethodParameterSpi)owner).getDeclaringMethod());
            }
            if (owner instanceof AnnotationSpi) {
                return SpiWithEcjUtils.methodScopeOf((JavaElementSpi)((AnnotationSpi)owner).getOwner());
            }
        }
        return null;
    }

    static AbstractMethodDeclaration sourceMethodOf(BindingMethodWithEcj b) {
        return SpiWithEcjUtils.sourceMethodOf(b.getInternalBinding());
    }

    static AbstractMethodDeclaration sourceMethodOf(MethodBinding b) {
        return SpiWithEcjUtils.nvl(b.original(), b).sourceMethod();
    }

    static <T> T nvl(T a, T b) {
        if (a == null) {
            return b;
        }
        return a;
    }

    static Annotation findAnnotationDeclaration(AnnotationSpi annotationSpi) {
        Annotation[] declaredAnnotations = null;
        AnnotatableSpi owner = annotationSpi.getOwner();
        if (owner instanceof AbstractTypeWithEcj) {
            b = ((AbstractTypeWithEcj)owner).getInternalBinding();
            if ((b = SpiWithEcjUtils.nvl(b.actualType(), b)) instanceof SourceTypeBinding) {
                declaredAnnotations = ((SourceTypeBinding)b).scope.referenceContext.annotations;
            }
        } else if (owner instanceof BindingMethodWithEcj) {
            b = ((BindingMethodWithEcj)owner).getInternalBinding();
            Annotation[] sourceMethod = SpiWithEcjUtils.sourceMethodOf((MethodBinding)b);
            if (sourceMethod != null) {
                declaredAnnotations = sourceMethod.annotations;
            }
        } else if (owner instanceof BindingFieldWithEcj) {
            b = ((BindingFieldWithEcj)owner).getInternalBinding();
            if ((b = (FieldBinding)SpiWithEcjUtils.nvl(b.original(), b)).sourceField() != null) {
                declaredAnnotations = b.sourceField().annotations;
            }
        } else if (owner instanceof BindingTypeParameterWithEcj) {
            b = ((BindingTypeParameterWithEcj)owner).getInternalBinding();
            b = (TypeVariableBinding)SpiWithEcjUtils.nvl(b.original(), b);
            if (b.declaringElement instanceof SourceTypeBinding) {
                declaredAnnotations = ((SourceTypeBinding)b.declaringElement).scope.referenceContext.annotations;
            }
        }
        if (declaredAnnotations != null && annotationSpi instanceof BindingAnnotationWithEcj) {
            AnnotationBinding binding = ((BindingAnnotationWithEcj)annotationSpi).getInternalBinding();
            for (Annotation decl : declaredAnnotations) {
                if (decl.getCompilerAnnotation() != binding) continue;
                return decl;
            }
            FindAnnotationVisitor v = new FindAnnotationVisitor(binding);
            for (Annotation decl : declaredAnnotations) {
                decl.traverse((ASTVisitor)v, (BlockScope)null);
                if (v.getResult() != null) break;
            }
            return v.getResult();
        }
        return null;
    }

    static MemberValuePair findAnnotationValueDeclaration(BindingAnnotationElementWithEcj a) {
        AnnotationSpi declaringAnnotation = a.getDeclaringAnnotation();
        Annotation annotationDeclaration = declaringAnnotation instanceof DeclarationAnnotationWithEcj ? ((DeclarationAnnotationWithEcj)declaringAnnotation).annotationDeclaration() : ((BindingAnnotationWithEcj)declaringAnnotation).annotationDeclaration();
        if (annotationDeclaration == null) {
            return null;
        }
        FindMemberValuePairVisitor v = new FindMemberValuePairVisitor(a.getInternalBinding());
        annotationDeclaration.traverse((ASTVisitor)v, (BlockScope)null);
        return v.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<BindingAnnotationWithEcj> createBindingAnnotations(AnnotatableSpi owner, Binding binding) {
        AnnotationBinding[] annotations;
        Object lock;
        Object object = lock = ((AbstractJavaEnvironment)owner.getJavaEnvironment()).lock();
        synchronized (object) {
            annotations = binding.getAnnotations();
        }
        return SpiWithEcjUtils.createBindingAnnotations(owner, annotations);
    }

    static List<BindingAnnotationWithEcj> createBindingAnnotations(AnnotatableSpi owner, AnnotationBinding[] annotationBindings) {
        if (annotationBindings == null || annotationBindings.length < 1) {
            return Collections.emptyList();
        }
        JavaEnvironmentWithEcj env = (JavaEnvironmentWithEcj)owner.getJavaEnvironment();
        return Arrays.stream(annotationBindings).filter(Objects::nonNull).map(annotation -> env.createBindingAnnotation(owner, (AnnotationBinding)annotation)).collect(Collectors.toList());
    }

    static List<DeclarationAnnotationWithEcj> createDeclarationAnnotations(JavaEnvironmentWithEcj env, AnnotatableSpi owner, Annotation[] annotations) {
        if (annotations == null || annotations.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.stream(annotations).map(annotation -> env.createDeclarationAnnotation(owner, (Annotation)annotation)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object compileExpression(Expression expression, ClassScope scopeForTypeLookup, JavaEnvironmentWithEcj env) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof NullLiteral) {
            return expression;
        }
        if (expression instanceof Literal) {
            if (expression.constant == null) {
                ((Literal)expression).computeConstant();
            }
            return expression.constant;
        }
        if (expression instanceof ArrayInitializer) {
            Expression[] array = ((ArrayInitializer)expression).expressions;
            if (array != null) {
                return Arrays.stream(array).map(item -> SpiWithEcjUtils.compileExpression(item, scopeForTypeLookup, env)).toArray();
            }
            return DefaultProblem.EMPTY_VALUES;
        }
        if (expression instanceof UnaryExpression) {
            Object candidate;
            int id;
            UnaryExpression ue = (UnaryExpression)expression;
            Expression inner = ue.expression;
            if (inner instanceof Literal && (id = SpiWithEcjUtils.getTypeIdForLiteral((Literal)inner)) > 0 && (candidate = SpiWithEcjUtils.compileExpression(inner, scopeForTypeLookup, env)) instanceof Constant) {
                return Constant.computeConstantOperation((Constant)((Constant)candidate), (int)id, (int)((expression.bits & 0x1F00) >> 8));
            }
        } else if (expression instanceof ClassLiteralAccess) {
            TypeReference type;
            TypeBinding val = ((ClassLiteralAccess)expression).targetType;
            if (val == null && (type = ((ClassLiteralAccess)expression).type) != null) {
                if (type.resolvedType == null && scopeForTypeLookup != null) {
                    Object candidate = env.lock();
                    synchronized (candidate) {
                        type.resolveType(scopeForTypeLookup);
                    }
                }
                val = type.resolvedType;
            }
            return val;
        }
        if (expression instanceof Annotation) {
            Annotation annotation = (Annotation)expression;
            AnnotationBinding compilerAnnotation = annotation.getCompilerAnnotation();
            if (compilerAnnotation == null) {
                Object type = env.lock();
                synchronized (type) {
                    annotation.resolveType((BlockScope)scopeForTypeLookup.referenceContext.staticInitializerScope);
                }
            }
            return annotation.getCompilerAnnotation();
        }
        if (expression instanceof Reference) {
            FieldBinding fieldBinding = null;
            if (expression instanceof NameReference) {
                Binding binding = ((NameReference)expression).binding;
                if (binding != null && binding.kind() == 1) {
                    fieldBinding = (FieldBinding)binding;
                } else if (expression instanceof QualifiedNameReference) {
                    ReferenceBinding ref;
                    FieldBinding field;
                    char[][] tokens = ((QualifiedNameReference)expression).tokens;
                    TypeBinding baseType = scopeForTypeLookup.getType(tokens, tokens.length - 1);
                    if (baseType instanceof ReferenceBinding && (field = (ref = (ReferenceBinding)baseType).getField(tokens[tokens.length - 1], true)) != null) {
                        return field;
                    }
                    String str = CharOperation.toString((char[][])tokens);
                    return StringConstant.fromValue((String)str);
                }
            } else {
                fieldBinding = ((Reference)expression).fieldBinding();
            }
            if (fieldBinding != null) {
                return fieldBinding;
            }
        }
        return ElementValuePair.getValue((Expression)expression);
    }

    static IMetaValue resolveCompiledValue(JavaEnvironmentWithEcj env, AnnotatableSpi owner, Object compiledValue, Supplier<Object> compiledValueSupplier) {
        if (compiledValue == null || Constant.NotAConstant.equals(compiledValue)) {
            return null;
        }
        if (compiledValue instanceof NullLiteral) {
            return MetaValueFactory.createNull();
        }
        if (compiledValue instanceof Constant) {
            return MetaValueFactory.createFromConstant((Constant)compiledValue);
        }
        if (compiledValue instanceof TypeBinding) {
            return MetaValueFactory.createFromType(SpiWithEcjUtils.bindingToType(env, (TypeBinding)compiledValue, () -> (TypeBinding)compiledValueSupplier.get()));
        }
        if (compiledValue instanceof FieldBinding) {
            FieldBinding fb = (FieldBinding)compiledValue;
            TypeSpi type = SpiWithEcjUtils.bindingToType(env, (TypeBinding)fb.declaringClass, () -> (TypeBinding)SpiWithEcjUtils.withNewElement(FieldBinding.class, f -> f.declaringClass, compiledValueSupplier));
            String name = new String(fb.name);
            if (type != null) {
                for (FieldSpi f : type.getFields()) {
                    if (!f.getElementName().equals(name)) continue;
                    return MetaValueFactory.createFromEnum((MemberSpi)f);
                }
            }
            return MetaValueFactory.createUnknown("ENUM " + fb.declaringClass.debugName() + "#" + name);
        }
        if (compiledValue instanceof AnnotationBinding) {
            AnnotationBinding a = (AnnotationBinding)compiledValue;
            return MetaValueFactory.createFromAnnotation(env.createBindingAnnotation(owner, a));
        }
        if (compiledValue.getClass().isArray()) {
            int n = Array.getLength(compiledValue);
            IMetaValue[] metaArray = new IMetaValue[n];
            if (n > 0) {
                metaArray = (IMetaValue[])IntStream.range(0, n).mapToObj(i -> SpiWithEcjUtils.resolveCompiledValue(env, owner, SpiWithEcjUtils.getElementFromArray(compiledValue, i), () -> SpiWithEcjUtils.lambda$resolveCompiledValue$15(i, (Supplier)compiledValueSupplier))).toArray(IMetaValue[]::new);
            }
            return MetaValueFactory.createArray(metaArray);
        }
        return MetaValueFactory.createUnknown(compiledValue);
    }

    static <T, R> R withNewElement(Class<T> type, Function<T, R> function, Supplier<Object> valueSupplier) {
        Object val = valueSupplier.get();
        if (val == null) {
            return null;
        }
        if (!type.isInstance(val)) {
            return null;
        }
        return function.apply(val);
    }

    static Object getElementFromArray(Object arr, int i) {
        if (i >= Array.getLength(arr)) {
            return null;
        }
        return Array.get(arr, i);
    }

    static int getTypeIdForLiteral(Literal l) {
        if (l instanceof StringLiteral) {
            return 11;
        }
        if (l instanceof NullLiteral) {
            return 12;
        }
        if (l instanceof FalseLiteral || l instanceof TrueLiteral) {
            return 5;
        }
        if (l instanceof IntLiteral) {
            return 10;
        }
        if (l instanceof FloatLiteral) {
            return 9;
        }
        if (l instanceof LongLiteral) {
            return 7;
        }
        if (l instanceof DoubleLiteral) {
            return 8;
        }
        if (l instanceof CharLiteral) {
            return 2;
        }
        return -1;
    }

    static boolean hasDeprecatedAnnotation(Collection<? extends AnnotationSpi> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return false;
        }
        return annotations.stream().filter(Objects::nonNull).anyMatch(annotation -> DEPRECATED_ANNOTATION_FQN.equals(annotation.getType().getName()));
    }

    private static /* synthetic */ Object lambda$resolveCompiledValue$15(int i, Supplier compiledValueSupplier) {
        return SpiWithEcjUtils.withNewElement(Object.class, t -> SpiWithEcjUtils.getElementFromArray(t, i), compiledValueSupplier);
    }

    private static /* synthetic */ TypeBinding lambda$bindingsToTypes$0(Supplier newElementLookupStrategy, TypeBinding binding) {
        return SpiWithEcjUtils.findBindingWithKey((TypeBinding[])newElementLookupStrategy.get(), binding.signableName());
    }

    private static final class FindAnnotationVisitor
    extends ASTVisitor {
        private final AnnotationBinding m_binding;
        private Annotation m_result;

        private FindAnnotationVisitor(AnnotationBinding binding) {
            this.m_binding = binding;
        }

        public Annotation getResult() {
            return this.m_result;
        }

        public boolean visit(MarkerAnnotation annotation, BlockScope scope) {
            return this.internalVisit((Annotation)annotation);
        }

        public boolean visit(NormalAnnotation annotation, BlockScope scope) {
            return this.internalVisit((Annotation)annotation);
        }

        public boolean visit(SingleMemberAnnotation annotation, BlockScope scope) {
            return this.internalVisit((Annotation)annotation);
        }

        private boolean internalVisit(Annotation annotation) {
            if (annotation.getCompilerAnnotation() == this.m_binding) {
                this.m_result = annotation;
            }
            return this.m_result == null;
        }
    }

    private static final class FindMemberValuePairVisitor
    extends ASTVisitor {
        private final ElementValuePair m_binding;
        private MemberValuePair m_result;

        private FindMemberValuePairVisitor(ElementValuePair binding) {
            this.m_binding = binding;
        }

        public MemberValuePair getResult() {
            return this.m_result;
        }

        public boolean visit(MemberValuePair pair, BlockScope scope) {
            if (pair.compilerElementPair == this.m_binding) {
                this.m_result = pair;
            }
            return this.m_result == null;
        }
    }
}

