/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.nls.ITranslationManagerListener;
import org.eclipse.scout.sdk.core.s.nls.Translations;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTablePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;

public class NlsEditor
extends EditorPart {
    public static final String EDITOR_ID = "org.eclipse.scout.sdk.s2e.ui.nlsEditor";
    private Path m_path;
    private NlsTablePage m_nlsTablePage;
    private ITranslationManagerListener m_listener;

    public void init(IEditorSite site, IEditorInput input) {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource != null && resource.exists()) {
            this.m_path = resource.getProject().getLocation().toFile().toPath();
        }
    }

    public boolean isDirty() {
        if (this.m_nlsTablePage == null) {
            return false;
        }
        return this.m_nlsTablePage.translationManager().isDirty();
    }

    public void createPartControl(Composite parent) {
        this.setPartName("Translations");
        if (this.path() == null) {
            return;
        }
        parent.getDisplay().asyncExec(() -> this.showMonitorDialogAndLoadContentAsync(parent));
    }

    protected void showMonitorDialogAndLoadContentAsync(Composite parent) {
        try {
            new ProgressMonitorDialog(parent.getShell()).run(true, true, monitor -> this.loadAndCreateContentAsync(parent, this.path(), monitor));
        }
        catch (InterruptedException | InvocationTargetException e) {
            SdkLog.error((CharSequence)"Error while loading the translations for path '{}'.", (Object[])new Object[]{this.path(), e});
        }
    }

    public void dispose() {
        super.dispose();
        if (this.m_nlsTablePage != null && this.m_listener != null) {
            this.m_nlsTablePage.translationManager().removeListener(this.m_listener);
        }
    }

    private void loadAndCreateContentAsync(Composite parent, Path modulePath, IProgressMonitor monitor) {
        EclipseEnvironment.runInEclipseEnvironment((e, p) -> {
            EclipseProgress progress = EclipseEnvironment.toScoutProgress((IProgressMonitor)monitor);
            progress.init(1000, (CharSequence)"Loading translation editor...", new Object[0]);
            try {
                Translations.createManager((Path)modulePath, (IEnvironment)e, (IProgress)progress.newChild(1000), (Translations.DependencyScope)Translations.DependencyScope.ALL).ifPresent(manager -> {
                    progress.monitor().setTaskName("Creating table...");
                    parent.getDisplay().syncExec(() -> this.createPageAsync((TranslationManager)manager, parent));
                });
            }
            catch (OperationCanceledException ex) {
                SdkLog.debug((CharSequence)"Translation manager creation has been canceled.", (Object[])new Object[]{ex});
            }
            catch (RuntimeException ex) {
                SdkLog.error((CharSequence)"Error loading translation manager.", (Object[])new Object[]{ex});
            }
        }).awaitDoneThrowingOnErrorOrCancel();
    }

    private void createPageAsync(TranslationManager manager, Composite parent) {
        parent.setRedraw(false);
        try {
            this.m_nlsTablePage = new NlsTablePage(parent, manager);
            this.m_listener = events -> parent.getDisplay().asyncExec(() -> this.firePropertyChange(257));
            manager.addListener(this.m_listener);
        }
        finally {
            parent.setRedraw(true);
        }
    }

    public Path path() {
        return this.m_path;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.m_nlsTablePage == null) {
            return;
        }
        EclipseEnvironment.runInEclipseEnvironment((env, progress) -> this.m_nlsTablePage.translationManager().flush((IEnvironment)env, (IProgress)progress));
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }
}

