/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.imports;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.imports.IImportCollector;
import org.eclipse.scout.sdk.core.java.imports.IImportValidator;
import org.eclipse.scout.sdk.core.java.imports.TypeReferenceDescriptor;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ImportValidator
implements IImportValidator {
    private IImportCollector m_importCollector;
    private final JavaTypes.ReferenceParser m_parser = new JavaTypes.ReferenceParser(this::handleTypeReference);

    public ImportValidator(IImportCollector collector) {
        this.setImportCollector(collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithImportCollector(Runnable r, Function<IImportCollector, IImportCollector> wrappingCollectorProvider) {
        IImportCollector origImportCollector = this.importCollector();
        IImportCollector wrappingCollector = wrappingCollectorProvider.apply(origImportCollector);
        try {
            this.setImportCollector(wrappingCollector);
            r.run();
        }
        finally {
            this.setImportCollector(origImportCollector);
        }
    }

    @Override
    public String useReference(CharSequence fullyQualifiedName) {
        return this.referenceParser().useReference(fullyQualifiedName);
    }

    protected CharSequence handleTypeReference(CharSequence fqn, int typeArgDepth) {
        TypeReferenceDescriptor descriptor = new TypeReferenceDescriptor(fqn, typeArgDepth > 0);
        IImportCollector collector = this.importCollector();
        String use = collector.checkExistingImports(descriptor);
        if (use == null) {
            use = collector.checkCurrentScope(descriptor);
            if (descriptor.isTypeArg()) {
                boolean inSamePackage;
                boolean foundInCurrentScope = use != null && use.indexOf(46) < 0;
                boolean bl = inSamePackage = Objects.equals(collector.getQualifier(), descriptor.getQualifier()) || Strings.isBlank((CharSequence)collector.getQualifier()) && Strings.isBlank((CharSequence)descriptor.getQualifier());
                if (foundInCurrentScope && inSamePackage) {
                    collector.registerElement(descriptor);
                }
            }
        }
        if (use == null) {
            use = collector.registerElement(descriptor);
        }
        return use;
    }

    @Override
    public IImportCollector importCollector() {
        return this.m_importCollector;
    }

    protected JavaTypes.ReferenceParser referenceParser() {
        return this.m_parser;
    }

    protected void setImportCollector(IImportCollector collector) {
        this.m_importCollector = (IImportCollector)Ensure.notNull((Object)collector);
    }
}

