/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.nio.file.Path;
import org.eclipse.scout.sdk.core.java.model.api.ClasspathContentKind;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.ClasspathSpi;

public class ClasspathEntryImplementor
implements IClasspathEntry {
    private final ClasspathSpi m_spi;

    public ClasspathEntryImplementor(ClasspathSpi classpathWithEcj) {
        this.m_spi = classpathWithEcj;
    }

    @Override
    public IJavaEnvironment javaEnvironment() {
        return this.m_spi.getJavaEnvironment().wrap();
    }

    @Override
    public ClasspathContentKind kind() {
        return switch (this.m_spi.getMode()) {
            case 1 -> ClasspathContentKind.SOURCE;
            case 2 -> ClasspathContentKind.BINARY;
            default -> ClasspathContentKind.MIXED;
        };
    }

    @Override
    public boolean isDirectory() {
        return this.m_spi.isDirectory();
    }

    @Override
    public boolean isSourceFolder() {
        return this.m_spi.isSourceFolder();
    }

    @Override
    public Path path() {
        return this.m_spi.getPath();
    }

    @Override
    public String encoding() {
        return this.m_spi.getEncoding();
    }

    @Override
    public ClasspathSpi unwrap() {
        return this.m_spi;
    }

    public final int hashCode() {
        return this.m_spi.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Classpath [path=");
        builder.append(this.path());
        builder.append(']');
        return builder.toString();
    }
}

