/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.internal.core.SearchCoreMessages;
import org.eclipse.search.internal.core.SearchCorePlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class TextSearchEngineRegistry {
    private static final String DEFAULT_PREFERENCE_NODE_ID = "org.eclipse.search";
    public static final String PREFERENCE_ENGINE_KEY = "org.eclipse.search.textSearchEngine";
    private static final String EXTENSION_POINT_ID = "org.eclipse.search.textSearchEngine";
    private static final String ENGINE_NODE_NAME = "textSearchEngine";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_LABEL = "label";
    private static final String ATTRIB_CLASS = "class";
    private TextSearchEngine fPreferredEngine = null;
    private String fPreferredEngineId = null;
    private String fgPreferenceNodeId;

    public void setPreferenceNodeId(String id) {
        this.fgPreferenceNodeId = id;
    }

    protected String getPreferenceNodeId() {
        return this.fgPreferenceNodeId == null ? DEFAULT_PREFERENCE_NODE_ID : this.fgPreferenceNodeId;
    }

    public TextSearchEngine getPreferred() {
        String preferredId = this.getPreferredEngineID();
        if (!Objects.equals(preferredId, this.fPreferredEngineId) || this.fPreferredEngine == null) {
            this.updateEngine(preferredId);
        }
        return this.fPreferredEngine;
    }

    private void updateEngine(String preferredId) {
        if (preferredId != null && !preferredId.isEmpty()) {
            TextSearchEngine engine = this.createFromExtension(preferredId);
            if (engine != null) {
                this.fPreferredEngineId = preferredId;
                this.fPreferredEngine = engine;
                return;
            }
            this.setPreferredEngineID("");
        }
        this.fPreferredEngineId = "";
        this.fPreferredEngine = TextSearchEngine.createDefault();
    }

    private String getPreferredEngineID() {
        String nodeId = this.getPreferenceNodeId();
        String preferedEngine = Platform.getPreferencesService().get("org.eclipse.search.textSearchEngine", null, (Preferences[])new IEclipsePreferences[]{InstanceScope.INSTANCE.getNode(nodeId)});
        return preferedEngine;
    }

    private void setPreferredEngineID(String id) {
        String pluginId = this.getPreferenceNodeId();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(pluginId);
        preferences.put("org.eclipse.search.textSearchEngine", id);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private TextSearchEngine createFromExtension(final String id) {
        final TextSearchEngine[] res = new TextSearchEngine[1];
        ISafeRunnable safe = new ISafeRunnable(){

            public void run() throws Exception {
                IConfigurationElement[] extensions;
                IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.search.textSearchEngine");
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement curr = iConfigurationElementArray[n2];
                    if (TextSearchEngineRegistry.ENGINE_NODE_NAME.equals(curr.getName()) && id.equals(curr.getAttribute(TextSearchEngineRegistry.ATTRIB_ID))) {
                        res[0] = (TextSearchEngine)curr.createExecutableExtension(TextSearchEngineRegistry.ATTRIB_CLASS);
                        return;
                    }
                    ++n2;
                }
            }

            public void handleException(Throwable e) {
                SearchCorePlugin.log(e);
            }
        };
        try {
            safe.run();
        }
        catch (Exception | LinkageError e) {
            safe.handleException(e);
        }
        return res[0];
    }

    public String[][] getAvailableEngines() {
        IConfigurationElement[] extensions;
        ArrayList<String[]> res = new ArrayList<String[]>();
        res.add(new String[]{SearchCoreMessages.TextSearchEngineRegistry_defaulttextsearch_label, ""});
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.search.textSearchEngine");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement engine = iConfigurationElementArray[n2];
            if (ENGINE_NODE_NAME.equals(engine.getName())) {
                res.add(new String[]{engine.getAttribute(ATTRIB_LABEL), engine.getAttribute(ATTRIB_ID)});
            }
            ++n2;
        }
        return (String[][])res.toArray((T[])new String[res.size()][]);
    }
}

