/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.mediawiki.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.parser.TableRowAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class TableBlock
extends Block {
    private static final Pattern rowCellSplitter = Pattern.compile("\\s*(\\|\\||!!)\\s*");
    private static final Pattern startPattern = Pattern.compile("\\s*\\{\\|\\s*(.+)?");
    private static final Pattern optionsPattern = Pattern.compile("([a-zA-Z]+)=\"([^\"]*)\"");
    private static final Pattern newRowPattern = Pattern.compile("\\s*\\|-\\s*(.+)?");
    private static final Pattern cellPattern = Pattern.compile("\\s*(\\||!)\\s*(.+)?");
    private static final Pattern cellSplitterPattern = Pattern.compile("\\s*(?:([^\\|\\[]+)?\\|)?\\s*(.+)?");
    private static final Pattern endPattern = Pattern.compile("\\s*\\|\\}\\s*(.+)?");
    private int blockLineCount;
    private Matcher matcher;
    private boolean openRow;
    private boolean openCell;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            TableAttributes attributes = new TableAttributes();
            String options = this.matcher.group(1);
            if (options != null) {
                Matcher optionsMatcher = optionsPattern.matcher(options);
                while (optionsMatcher.find()) {
                    String optionName = optionsMatcher.group(1);
                    String optionValue = optionsMatcher.group(2);
                    if (optionName.equalsIgnoreCase("id")) {
                        attributes.setId(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("style")) {
                        attributes.setCssStyle(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("class")) {
                        attributes.setCssClass(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("title")) {
                        attributes.setTitle(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("border")) {
                        attributes.setBorder(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("summary")) {
                        attributes.setSummary(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("width")) {
                        attributes.setWidth(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("frame")) {
                        attributes.setFrame(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("rules")) {
                        attributes.setRules(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("cellspacing")) {
                        attributes.setCellspacing(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("cellpadding")) {
                        attributes.setCellpadding(optionValue);
                        continue;
                    }
                    if (!optionName.equalsIgnoreCase("bgcolor")) continue;
                    attributes.setBgcolor(optionValue);
                }
            }
            this.builder.beginBlock(DocumentBuilder.BlockType.TABLE, (Attributes)attributes);
            return -1;
        }
        Matcher newRowMatcher = newRowPattern.matcher(line);
        if (newRowMatcher.matches()) {
            TableRowAttributes attributes = new TableRowAttributes();
            String newRowOptions = newRowMatcher.group(1);
            if (newRowOptions != null) {
                Matcher optionsMatcher = optionsPattern.matcher(newRowOptions);
                while (optionsMatcher.find()) {
                    String optionName = optionsMatcher.group(1);
                    String optionValue = optionsMatcher.group(2);
                    if (optionName.equalsIgnoreCase("id")) {
                        attributes.setId(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("style")) {
                        attributes.setCssStyle(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("class")) {
                        attributes.setCssClass(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("title")) {
                        attributes.setTitle(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("align")) {
                        attributes.setAlign(optionValue);
                        continue;
                    }
                    if (optionName.equalsIgnoreCase("valign")) {
                        attributes.setValign(optionValue);
                        continue;
                    }
                    if (!optionName.equalsIgnoreCase("bgcolor")) continue;
                    attributes.setBgcolor(optionValue);
                }
            }
            this.openRow(newRowMatcher.start(), attributes);
            return -1;
        }
        Matcher endMatcher = endPattern.matcher(line);
        if (endMatcher.matches()) {
            this.setClosed(true);
            return endMatcher.start(1);
        }
        Matcher cellMatcher = cellPattern.matcher(line);
        if (cellMatcher.matches()) {
            String kind = cellMatcher.group(1);
            DocumentBuilder.BlockType type = "!".equals(kind) ? DocumentBuilder.BlockType.TABLE_CELL_HEADER : DocumentBuilder.BlockType.TABLE_CELL_NORMAL;
            String contents = cellMatcher.group(2);
            if (contents == null) {
                this.openCell(cellMatcher.start(), type, new TableCellAttributes());
                return -1;
            }
            int contentsStart = cellMatcher.start(2);
            this.emitCells(contentsStart, type, contents);
            return -1;
        }
        return -1;
    }

    private void emitCells(int contentsStart, DocumentBuilder.BlockType type, String contents) {
        int lastEnd = 0;
        Matcher matcher = rowCellSplitter.matcher(contents);
        while (matcher.find()) {
            int found = matcher.start();
            String cell = found > lastEnd ? contents.substring(lastEnd, found) : "";
            this.emitCell(lastEnd + contentsStart, type, cell);
            String splitterSpec = matcher.group(1);
            type = "!!".equals(splitterSpec) ? DocumentBuilder.BlockType.TABLE_CELL_HEADER : DocumentBuilder.BlockType.TABLE_CELL_NORMAL;
            lastEnd = matcher.end();
        }
        if (lastEnd < contents.length()) {
            this.emitCell(lastEnd + contentsStart, type, contents.substring(lastEnd));
        }
    }

    private void emitCell(int lineCharacterOffset, DocumentBuilder.BlockType type, String cell) {
        String cellContents;
        Matcher cellSplitterMatcher = cellSplitterPattern.matcher(cell);
        if (!cellSplitterMatcher.matches()) {
            throw new IllegalStateException();
        }
        String cellOptions = cellSplitterMatcher.group(1);
        TableCellAttributes attributes = new TableCellAttributes();
        if (cellOptions != null) {
            Matcher optionsMatcher = optionsPattern.matcher(cellOptions);
            while (optionsMatcher.find()) {
                String optionName = optionsMatcher.group(1);
                String optionValue = optionsMatcher.group(2);
                if (optionName.equalsIgnoreCase("id")) {
                    attributes.setId(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("style")) {
                    attributes.setCssStyle(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("class")) {
                    attributes.setCssClass(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("title")) {
                    attributes.setTitle(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("align")) {
                    attributes.setAlign(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("valign")) {
                    attributes.setValign(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("bgcolor")) {
                    attributes.setBgcolor(optionValue);
                    continue;
                }
                if (optionName.equalsIgnoreCase("colspan")) {
                    attributes.setColspan(optionValue);
                    continue;
                }
                if (!optionName.equalsIgnoreCase("rowspan")) continue;
                attributes.setRowspan(optionValue);
            }
        }
        if ((cellContents = cellSplitterMatcher.group(2)) == null) {
            this.openCell(lineCharacterOffset + cellSplitterMatcher.end(), type, attributes);
        } else {
            int contentsStart = cellSplitterMatcher.start(2);
            this.openCell(lineCharacterOffset, type, attributes);
            this.markupLanguage.emitMarkupLine(this.parser, this.state, lineCharacterOffset + contentsStart, cellContents, 0);
        }
    }

    private void openRow(int lineOffset, TableRowAttributes attributes) {
        this.closeRow();
        this.state.setLineCharacterOffset(lineOffset);
        this.builder.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, (Attributes)attributes);
        this.openRow = true;
    }

    private void closeRow() {
        this.closeCell();
        if (this.openRow) {
            this.builder.endBlock();
            this.openRow = false;
        }
    }

    private void openCell(int lineOffset, DocumentBuilder.BlockType type, TableCellAttributes attributes) {
        this.closeCell();
        if (!this.openRow) {
            this.openRow(lineOffset, new TableRowAttributes());
        }
        this.state.setLineCharacterOffset(lineOffset);
        this.builder.beginBlock(type, (Attributes)attributes);
        this.openCell = true;
    }

    private void closeCell() {
        if (this.openCell) {
            this.builder.endBlock();
            this.openCell = false;
        }
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.openRow = false;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.closeCell();
            this.closeRow();
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    public boolean beginNesting() {
        return !this.isClosed();
    }

    public int findCloseOffset(String line, int lineOffset) {
        if (!this.isClosed() && !this.checkAtNewTableRow(line, lineOffset)) {
            return -1;
        }
        return lineOffset;
    }

    private boolean checkAtNewTableRow(String line, int lineOffset) {
        if (lineOffset < line.length()) {
            Matcher m = cellPattern.matcher(line);
            m.region(lineOffset, line.length());
            return m.matches();
        }
        return false;
    }

    public boolean canResume(String line, int lineOffset) {
        return this.checkAtNewTableRow(line, lineOffset);
    }
}

