/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.IHeader;
import org.eclipse.pde.internal.core.builders.JarManifestErrorReporter;
import org.osgi.framework.BundleException;

public class JarManifestHeader
implements IHeader {
    private final JarManifestErrorReporter fErrorReporter;
    private final int fLineNumber;
    private int fLines;
    private ManifestElement[] fManifestElements;
    private final String fName;
    private String fValue;

    public JarManifestHeader(String name, String value, int lineNumber, JarManifestErrorReporter errorReporter) {
        this.fName = name;
        this.fValue = value;
        this.fLineNumber = lineNumber;
        this.fErrorReporter = errorReporter;
        this.fLines = 1;
    }

    public void append(String value) {
        this.fValue = String.valueOf(this.fValue) + value;
        ++this.fLines;
    }

    @Override
    public ManifestElement[] getElements() {
        if (this.fManifestElements == null) {
            if (this.getValue().trim().length() > 0) {
                try {
                    this.fManifestElements = ManifestElement.parseHeader((String)this.getName(), (String)this.getValue());
                }
                catch (BundleException be) {
                    this.fManifestElements = new ManifestElement[0];
                    if (this.fErrorReporter != null) {
                        String message = NLS.bind((String)PDECoreMessages.BundleErrorReporter_parseHeader, (Object)this.getName());
                        this.fErrorReporter.report(message, this.getLineNumber(), 0, "fatal");
                    }
                }
            } else {
                this.fManifestElements = new ManifestElement[0];
            }
        }
        return this.fManifestElements;
    }

    @Override
    public int getLineNumber() {
        return this.fLineNumber;
    }

    @Override
    public int getLinesSpan() {
        return this.fLines;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    public String toString() {
        return this.fName + "=" + this.fValue;
    }
}

