/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.Maven;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.launch.ClasspathEntry;
import org.eclipse.m2e.core.internal.launch.DefaultWorkspaceRuntime;
import org.eclipse.m2e.core.internal.launch.MavenEmbeddedRuntime;
import org.eclipse.m2e.core.internal.launch.MavenExternalRuntime;
import org.eclipse.m2e.core.internal.launch.MavenWorkspaceRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@Component(service={MavenRuntimeManagerImpl.class})
public class MavenRuntimeManagerImpl {
    public static final String DEFAULT = "DEFAULT";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String EXTERNAL = "EXTERNAL";
    private final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    @Reference
    private IPreferencesService preferenceStore;

    public MavenRuntimeManagerImpl() {
        this.preferencesLookup[0] = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        this.preferencesLookup[1] = DefaultScope.INSTANCE.getNode("org.eclipse.m2e.core");
    }

    public AbstractMavenRuntime getRuntime(String name) {
        if (name == null || name.trim().isEmpty() || DEFAULT.equals(name.trim())) {
            return this.getDefaultRuntime();
        }
        AbstractMavenRuntime runtime = this.getRuntimes().get(name);
        if (runtime == null) {
            runtime = this.getDefaultRuntime();
        }
        return runtime;
    }

    private AbstractMavenRuntime getDefaultRuntime() {
        String name = this.preferenceStore.get("eclipse.m2.defaultRuntime", null, (Preferences[])this.preferencesLookup);
        Map<String, AbstractMavenRuntime> runtimes = this.getRuntimes();
        AbstractMavenRuntime runtime = runtimes.get(name);
        if (runtime == null || !runtime.isAvailable()) {
            runtime = runtimes.get(EMBEDDED);
        }
        return runtime;
    }

    public List<AbstractMavenRuntime> getMavenRuntimes() {
        ArrayList<AbstractMavenRuntime> mavenRuntimes = new ArrayList<AbstractMavenRuntime>();
        for (AbstractMavenRuntime mavenRuntime : this.getRuntimes().values()) {
            if (!mavenRuntime.isAvailable()) continue;
            mavenRuntimes.add(mavenRuntime);
        }
        return mavenRuntimes;
    }

    public List<AbstractMavenRuntime> getMavenRuntimes(boolean available) {
        ArrayList<AbstractMavenRuntime> mavenRuntimes = new ArrayList<AbstractMavenRuntime>();
        for (AbstractMavenRuntime mavenRuntime : this.getRuntimes().values()) {
            if (available && !mavenRuntime.isAvailable()) continue;
            mavenRuntimes.add(mavenRuntime);
        }
        return mavenRuntimes;
    }

    public void reset() {
        this.preferencesLookup[0].remove("eclipse.m2.runtimes");
        this.preferencesLookup[0].remove("eclipse.m2.defaultRuntime");
        this.removeRuntimePreferences();
        this.flush();
    }

    public void setDefaultRuntime(AbstractMavenRuntime runtime) {
        if (runtime == null) {
            this.preferencesLookup[0].remove("eclipse.m2.defaultRuntime");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.defaultRuntime", runtime.getName());
        }
        this.flush();
    }

    private void flush() {
        try {
            this.preferencesLookup[0].flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void setRuntimes(List<AbstractMavenRuntime> runtimes) {
        this.removeRuntimePreferences();
        HashSet<String> names = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        for (AbstractMavenRuntime runtime : runtimes) {
            String name = runtime.getName();
            if (!names.add(name)) {
                throw new IllegalArgumentException();
            }
            if (!runtime.isEditable()) continue;
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(name);
            if (runtime.isLegacy()) continue;
            Preferences runtimeNode = this.getRuntimePreferences(name, true);
            runtimeNode.put("type", this.getRuntimeType(runtime));
            runtimeNode.put("location", runtime.getLocation());
            String extensions = this.encodeClasspath(runtime.getExtensions());
            if (extensions != null) {
                runtimeNode.put("extensions", extensions);
                continue;
            }
            runtimeNode.remove("extensions");
        }
        this.preferencesLookup[0].put("eclipse.m2.runtimes", sb.toString());
        this.flush();
    }

    private void removeRuntimePreferences() {
        try {
            if (this.preferencesLookup[0].nodeExists("eclipse.m2.runtimesNodes")) {
                this.preferencesLookup[0].node("eclipse.m2.runtimesNodes").removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private String getRuntimeType(AbstractMavenRuntime runtime) {
        if (runtime instanceof MavenExternalRuntime) {
            return EXTERNAL;
        }
        if (runtime instanceof MavenWorkspaceRuntime) {
            return WORKSPACE;
        }
        throw new IllegalArgumentException();
    }

    private Preferences getRuntimePreferences(String name, boolean create) {
        Preferences runtimesNode = this.preferencesLookup[0].node("eclipse.m2.runtimesNodes");
        try {
            if (runtimesNode.nodeExists(name) || create) {
                return runtimesNode.node(name);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return null;
    }

    private String encodeClasspath(List<ClasspathEntry> classpath) {
        if (classpath == null || classpath.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ClasspathEntry cpe : classpath) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append(cpe.toExternalForm());
        }
        return sb.toString();
    }

    private List<ClasspathEntry> decodeClasspath(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>();
        String[] stringArray = string.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            ClasspathEntry decoded = ClasspathEntry.fromExternalForm(entry);
            if (decoded != null) {
                result.add(decoded);
            }
            ++n2;
        }
        return result;
    }

    public Map<String, AbstractMavenRuntime> getRuntimes() {
        LinkedHashMap<String, AbstractMavenRuntime> runtimes = new LinkedHashMap<String, AbstractMavenRuntime>();
        Bundle defaultRuntimeBundle = FrameworkUtil.getBundle(Maven.class);
        runtimes.put(EMBEDDED, new MavenEmbeddedRuntime(defaultRuntimeBundle, EMBEDDED, MavenEmbeddedRuntime.getMavenVersionFromBundle(defaultRuntimeBundle)));
        this.getMavenRuntimeBundles().filter(rtb -> rtb != defaultRuntimeBundle).forEach(rtb -> {
            String key;
            String mavenVersionFromBundle = MavenEmbeddedRuntime.getMavenVersionFromBundle(rtb);
            if (mavenVersionFromBundle == null) {
                Version version = rtb.getVersion();
                key = "EMBEDDED_" + version.getMajor() + "_" + version.getMinor() + "_" + version.getMicro();
            } else {
                key = "EMBEDDED_" + mavenVersionFromBundle.replace('.', '_');
            }
            runtimes.put(key, new MavenEmbeddedRuntime((Bundle)rtb, key, mavenVersionFromBundle));
        });
        runtimes.put(WORKSPACE, new DefaultWorkspaceRuntime());
        String runtimesPreference = this.preferenceStore.get("eclipse.m2.runtimes", null, (Preferences[])this.preferencesLookup);
        if (runtimesPreference != null && runtimesPreference.length() > 0) {
            String[] stringArray = runtimesPreference.split("\\|");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Preferences preferences = this.getRuntimePreferences(name, false);
                AbstractMavenRuntime runtime = preferences == null ? new MavenExternalRuntime(name) : this.createRuntime(name, preferences);
                runtimes.put(runtime.getName(), runtime);
                ++n2;
            }
        }
        return runtimes;
    }

    private Stream<Bundle> getMavenRuntimeBundles() {
        Bundle myBundle = FrameworkUtil.getBundle(MavenRuntimeManagerImpl.class);
        if (myBundle == null) {
            return Stream.empty();
        }
        BundleContext bundleContext = myBundle.getBundleContext();
        if (bundleContext == null) {
            return Stream.empty();
        }
        return Arrays.stream(bundleContext.getBundles()).filter(bundle -> "org.eclipse.m2e.maven.runtime".equals(bundle.getSymbolicName()));
    }

    private AbstractMavenRuntime createRuntime(String name, Preferences preferences) {
        String location = preferences.get("location", null);
        String type = preferences.get("type", EXTERNAL);
        AbstractMavenRuntime runtime = WORKSPACE.equals(type) ? new MavenWorkspaceRuntime(name) : new MavenExternalRuntime(name, location);
        runtime.setExtensions(this.decodeClasspath(preferences.get("extensions", null)));
        return runtime;
    }
}

