/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.StringUtils;

public class EclipseGitProgressTransformer
implements ProgressMonitor {
    private static long UPDATE_INTERVAL = TimeUnit.MILLISECONDS.toMillis(100L);
    private final SubMonitor root;
    private String msg;
    private int lastWorked;
    private int lastShown;
    private int totalWork;
    private long lastUpdatedAt;
    private Boolean showDuration;
    private Instant startTime;

    public EclipseGitProgressTransformer(IProgressMonitor eclipseMonitor) {
        this.root = SubMonitor.convert((IProgressMonitor)eclipseMonitor);
        this.startTime = Instant.now();
    }

    public void start(int totalTasks) {
        this.startTime = Instant.now();
    }

    public void beginTask(String name, int total) {
        this.startTime = Instant.now();
        this.msg = name;
        this.lastWorked = 0;
        this.lastShown = 0;
        this.lastUpdatedAt = 0L;
        this.totalWork = total <= 0 ? 0 : total;
        this.root.subTask(this.msg);
    }

    public void update(int work) {
        if (work <= 0) {
            return;
        }
        int cmp = this.lastWorked + work;
        StringBuilder m = new StringBuilder();
        if (this.totalWork == 0) {
            long now = System.currentTimeMillis();
            if (now < this.lastUpdatedAt || now - this.lastUpdatedAt > UPDATE_INTERVAL) {
                if (!StringUtils.isEmptyOrNull((String)this.msg)) {
                    m.append(this.msg).append(", ");
                }
                m.append(cmp);
                this.appendDuration(m, this.elapsedTime());
                this.root.subTask(m.toString());
                this.root.setWorkRemaining(100);
                this.root.worked(1);
                this.lastUpdatedAt = now;
            }
        } else if (this.lastShown == 0 || cmp * 100 / this.totalWork != this.lastShown * 100 / this.totalWork) {
            m.append(this.msg);
            m.append(": ");
            while (m.length() < 25) {
                m.append(' ');
            }
            String twstr = String.valueOf(this.totalWork);
            String cmpstr = String.valueOf(cmp);
            while (cmpstr.length() < twstr.length()) {
                cmpstr = String.valueOf(' ') + cmpstr;
            }
            int pcnt = cmp * 100 / this.totalWork;
            if (pcnt < 100) {
                m.append(' ');
            }
            if (pcnt < 10) {
                m.append(' ');
            }
            m.append(pcnt);
            m.append("% (");
            m.append(cmpstr);
            m.append('/');
            m.append(twstr);
            m.append(')');
            this.appendDuration(m, this.elapsedTime());
            this.root.subTask(m.toString());
            this.root.setWorkRemaining(100);
            this.root.worked(1);
            this.lastShown = cmp;
        }
        this.lastWorked = cmp;
    }

    public void endTask() {
    }

    public boolean isCancelled() {
        return this.root.isCanceled();
    }

    public void showDuration(boolean enabled) {
        this.showDuration = enabled;
    }

    private boolean showDuration() {
        return this.showDuration != null && this.showDuration != false || GitTraceLocation.PERFORMANCE.isActive();
    }

    private Duration elapsedTime() {
        return Duration.between(this.startTime, Instant.now());
    }

    private void appendDuration(StringBuilder s, Duration duration) {
        if (!this.showDuration()) {
            return;
        }
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        s.append(" [");
        if (hours > 0L) {
            s.append(hours).append(':');
            s.append(String.format("%02d", minutes)).append(':');
            s.append(String.format("%02d", seconds));
        } else if (minutes > 0) {
            s.append(minutes).append(':');
            s.append(String.format("%02d", seconds));
        } else {
            s.append(seconds);
        }
        s.append('.').append(String.format("%03d", duration.toMillisPart()));
        if (hours > 0L) {
            s.append('h');
        } else if (minutes > 0) {
            s.append('m');
        } else {
            s.append('s');
        }
        s.append(']');
    }
}

