/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.details;

import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.ISimpleCSCommandKeyListener;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.NewCommandKeyEvent;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSCommandManager;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SimpleCSCommandComboPart
extends ComboPart
implements ISimpleCSCommandKeyListener,
DisposeListener {
    private int fNewCommandKeyIndex = -1;
    private int fComboEntryLimit = -1;

    public void addDisposeListener(DisposeListener listener) {
        if (this.combo == null) {
            return;
        }
        if (this.combo instanceof Combo) {
            this.combo.addDisposeListener(listener);
        } else {
            this.combo.addDisposeListener(listener);
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit, int style) {
        super.createControl(parent, toolkit, style);
        SimpleCSCommandManager.Instance().addCommandKeyListener(this);
        this.addDisposeListener(this);
    }

    @Override
    public void newCommandKey(NewCommandKeyEvent event) {
        String key = event.getKey();
        this.putValueInCombo(key, this.fNewCommandKeyIndex);
    }

    private void putValueInCombo(String key, int index) {
        if (this.indexOf(key) != -1) {
            return;
        }
        if (this.getItemCount() >= this.fComboEntryLimit) {
            this.removeLeastRecentEntry();
        }
        if (index < 0) {
            this.add(key);
        } else {
            this.add(key, index);
        }
    }

    private void removeLeastRecentEntry() {
        int entryCount = this.getItemCount();
        if (entryCount <= 1) {
            return;
        }
        int lastEntry = entryCount - 1;
        if (lastEntry != this.getSelectionIndex()) {
            this.remove(lastEntry);
            return;
        }
        int secondlastEntry = lastEntry - 1;
        this.remove(secondlastEntry);
    }

    public void setComboEntryLimit(int limit) {
        this.fComboEntryLimit = limit;
    }

    public int getComboEntryLimit() {
        return this.fComboEntryLimit;
    }

    public void setNewCommandKeyIndex(int newCommandKeyIndex) {
        this.fNewCommandKeyIndex = newCommandKeyIndex;
    }

    public int getNewCommandKeyIndex() {
        return this.fNewCommandKeyIndex;
    }

    public void widgetDisposed(DisposeEvent e) {
        SimpleCSCommandManager.Instance().removeCommandKeyListener(this);
    }

    public void populate() {
        for (String key : SimpleCSCommandManager.Instance().getKeys()) {
            this.add(key);
        }
    }

    public void putValue(String key, String value) {
        this.putValue(key, value, -1);
    }

    public void putValue(String key, String value, int index) {
        SimpleCSCommandManager manager = SimpleCSCommandManager.Instance();
        this.putValueInCombo(key, index);
        manager.put(key, value);
    }

    public String getValue(String key) {
        return SimpleCSCommandManager.Instance().get(key);
    }
}

