/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.util.Preconditions;

class HtmlEntities {
    private static HtmlEntities instance = new HtmlEntities();
    private final Map<String, List<String>> nameToNumericEntityReferences = HtmlEntities.readHtmlEntities();
    private final Map<String, String> nameToStringEquivalent = this.createNameToStringEquivalent(this.nameToNumericEntityReferences);

    private static Map<String, List<String>> readHtmlEntities() {
        HashMap<String, List> builder = new HashMap<String, List>();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(HtmlDocumentBuilder.class.getResourceAsStream("html-entity-references.txt"), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] lineItems = line.split(" ");
                    Preconditions.checkState(lineItems.length > 1);
                    int x = 1;
                    while (x < lineItems.length) {
                        List list = builder.computeIfAbsent(lineItems[0], i -> new ArrayList());
                        list.add(lineItems[x]);
                        ++x;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> List.copyOf((Collection)entry.getValue())));
    }

    public static HtmlEntities instance() {
        return instance;
    }

    private HtmlEntities() {
    }

    public List<String> nameToEntityReferences(String name) {
        List<String> list = this.nameToNumericEntityReferences.get(name);
        return list != null ? list : Collections.emptyList();
    }

    public String nameToStringEquivalent(String name) {
        return this.nameToStringEquivalent.get(name);
    }

    private Map<String, String> createNameToStringEquivalent(Map<String, List<String>> nameToNumericEntityReferences) {
        return nameToNumericEntityReferences.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> this.stringEquivalent((Collection)entry.getValue())));
    }

    private String stringEquivalent(Collection<String> collection) {
        return Normalizer.normalize(collection.stream().map(this::numericEntityToString).collect(Collectors.joining()), Normalizer.Form.NFC);
    }

    private String numericEntityToString(String s) {
        Preconditions.checkArgument(s.charAt(0) == '#', new String[0]);
        return String.valueOf((char)Integer.parseInt(s.substring(1)));
    }
}

