/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.launching.AntLaunching;
import org.eclipse.ant.internal.launching.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.AbstractRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AntHomeClasspathEntry
extends AbstractRuntimeClasspathEntry {
    public static final String TYPE_ID = "org.eclipse.ant.ui.classpathentry.antHome";
    private String antHomeLocation = null;

    public AntHomeClasspathEntry() {
        this.antHomeLocation = null;
    }

    public AntHomeClasspathEntry(String antHome) {
        this.antHomeLocation = antHome;
    }

    protected void buildMemento(Document document, Element memento) throws CoreException {
        if (this.antHomeLocation == null) {
            memento.setAttribute("default", "true");
        } else {
            memento.setAttribute("antHome", IPath.fromOSString((String)this.antHomeLocation).toString());
        }
    }

    public void initializeFrom(Element memento) throws CoreException {
        String antHome = memento.getAttribute("antHome");
        if (antHome != null && antHome.length() > 0) {
            IPath path = IPath.fromOSString((String)antHome);
            this.antHomeLocation = path.toOSString();
        } else {
            this.antHomeLocation = null;
        }
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public IRuntimeClasspathEntry[] getRuntimeClasspathEntries(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> libs = new ArrayList<IRuntimeClasspathEntry>(40);
        AntCorePreferences preferences = AntCorePlugin.getPlugin().getPreferences();
        if (this.antHomeLocation == null) {
            IAntClasspathEntry[] iAntClasspathEntryArray = preferences.getAntHomeClasspathEntries();
            int n = iAntClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAntClasspathEntry entry = iAntClasspathEntryArray[n2];
                libs.add(JavaRuntime.newStringVariableClasspathEntry((String)entry.getLabel()));
                ++n2;
            }
        } else {
            IPath libDir = IPath.fromOSString((String)this.antHomeLocation).append("lib");
            String[] stringArray = this.resolveAntHome().list();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String name = stringArray[n3];
                IPath path = IPath.fromOSString((String)name);
                String fileExtension = path.getFileExtension();
                if ("jar".equalsIgnoreCase(fileExtension)) {
                    libs.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)libDir.append(path)));
                }
                ++n3;
            }
        }
        return libs.toArray(new IRuntimeClasspathEntry[libs.size()]);
    }

    public File resolveAntHome() throws CoreException {
        if (this.antHomeLocation == null) {
            return null;
        }
        IPath libDir = IPath.fromOSString((String)this.antHomeLocation).append("lib");
        File lib = libDir.toFile();
        File parentDir = lib.getParentFile();
        if (parentDir == null || !parentDir.exists()) {
            this.abort(MessageFormat.format(AntLaunchConfigurationMessages.AntHomeClasspathEntry_10, this.antHomeLocation), null);
        }
        if (!lib.exists() || !lib.isDirectory()) {
            this.abort(MessageFormat.format(AntLaunchConfigurationMessages.AntHomeClasspathEntry_11, this.antHomeLocation), null);
        }
        return lib;
    }

    protected void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, AntLaunching.getUniqueIdentifier(), 150, message, exception);
        throw new CoreException((IStatus)status);
    }

    public String getName() {
        if (this.antHomeLocation == null) {
            return AntLaunchConfigurationMessages.AntHomeClasspathEntry_8;
        }
        return MessageFormat.format(AntLaunchConfigurationMessages.AntHomeClasspathEntry_9, this.antHomeLocation);
    }

    public int getType() {
        return 5;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof AntHomeClasspathEntry && this.equalsOrNull(this.antHomeLocation, ((AntHomeClasspathEntry)((Object)obj)).antHomeLocation);
    }

    private boolean equalsOrNull(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public void setAntHome(String path) {
        this.antHomeLocation = path;
    }

    public String getAntHome() {
        if (this.antHomeLocation == null) {
            return AntCorePlugin.getPlugin().getPreferences().getAntHome();
        }
        return this.antHomeLocation;
    }
}

