/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;

public class LaunchListener
implements ILaunchListener,
IDebugEventSetListener {
    private final ArrayList<ILaunch> managedLaunches = new ArrayList();

    public void manage(ILaunch launch) {
        if (this.managedLaunches.isEmpty()) {
            this.hookListener(true);
        }
        if (!this.managedLaunches.contains(launch)) {
            this.managedLaunches.add(launch);
        }
    }

    public void launchRemoved(ILaunch launch) {
        this.update(launch, true);
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    private void update(ILaunch launch, boolean remove) {
        if (this.managedLaunches.contains(launch) && (remove || launch.isTerminated())) {
            this.managedLaunches.remove(launch);
            if (this.managedLaunches.isEmpty()) {
                this.hookListener(false);
            }
        }
    }

    private void hookListener(boolean add) {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        ILaunchManager launchManager = debugPlugin.getLaunchManager();
        if (add) {
            launchManager.addLaunchListener((ILaunchListener)this);
            debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
        } else {
            launchManager.removeLaunchListener((ILaunchListener)this);
            debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    private void doRestart(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
            copy.setAttribute("restart", true);
            copy.launch(launch.getLaunchMode(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            IStatus status = Status.error(null, (Throwable)e);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(status);
            if (statusHandler == null) {
                PDELaunchingPlugin.log(e);
            }
            try {
                statusHandler.handleStatus(status, null);
            }
            catch (CoreException e1) {
                PDELaunchingPlugin.log(e);
            }
        }
    }

    public void shutdown() {
        this.hookListener(false);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process;
            ILaunch launch;
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (source instanceof IProcess && event.getKind() == 8 && (launch = (process = (IProcess)source).getLaunch()) != null) {
                try {
                    this.launchTerminated(launch, process.getExitValue());
                }
                catch (DebugException debugException) {
                }
                catch (CoreException e) {
                    PDELaunchingPlugin.log(e);
                }
            }
            ++n2;
        }
    }

    private void launchTerminated(ILaunch launch, int returnValue) throws CoreException {
        if (this.managedLaunches.contains(launch)) {
            this.update(launch, true);
            if (returnValue == IApplication.EXIT_RESTART) {
                this.doRestart(launch);
                return;
            }
            if (returnValue == 15) {
                Status status = new Status(4, "org.eclipse.pde.launching", 2000, null, null);
                IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (statusHandler == null) {
                    PDELaunchingPlugin.log((IStatus)status);
                } else {
                    ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
                    String workspace = launchConfiguration.getAttribute("location", "");
                    statusHandler.handleStatus((IStatus)status, (Object)new Object[]{workspace, launchConfiguration, launch.getLaunchMode()});
                }
                return;
            }
            if (returnValue == 13) {
                IStatus status = Status.error((String)PDEMessages.Launcher_error_code13);
                IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(status);
                if (statusHandler == null) {
                    PDELaunchingPlugin.log(status);
                } else {
                    statusHandler.handleStatus(status, (Object)launch);
                }
                return;
            }
        }
    }

    public static File getMostRecentLogFile(ILaunchConfiguration configuration) throws CoreException {
        File configDir;
        File[] children;
        if (configuration == null) {
            return null;
        }
        File latest = null;
        String workspace = LaunchArgumentsHelper.getWorkspaceLocation(configuration);
        if (workspace.length() > 0 && !(latest = new File(workspace, ".metadata/.log")).exists()) {
            latest = null;
        }
        if ((children = (configDir = LaunchConfigurationHelper.getConfigurationLocation(configuration)).listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                if (!children[i].isDirectory() && children[i].getName().endsWith(".log") && (latest == null || latest.lastModified() < children[i].lastModified())) {
                    latest = children[i];
                }
                ++i;
            }
        }
        return latest;
    }
}

