/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.util.emf.workbench.nature;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.jem.util.logger.proxy.Logger;

public class EMFNatureRegistry {
    private static final String NATURE_REGISTRATION_POINT = "org.eclipse.jem.util.nature_registration";
    private static final String NATURE = "nature";
    private static final String STATIC_ID = "id";
    private static EMFNatureRegistry singleton;
    public final Set REGISTERED_NATURE_IDS = new HashSet();

    private EMFNatureRegistry() {
        this.readRegistry();
    }

    public static EMFNatureRegistry singleton() {
        if (singleton == null) {
            singleton = new EMFNatureRegistry();
        }
        return singleton;
    }

    protected void readRegistry() {
        IExtensionRegistry r = Platform.getExtensionRegistry();
        IConfigurationElement[] ce = r.getConfigurationElementsFor(NATURE_REGISTRATION_POINT);
        int i = 0;
        while (i < ce.length) {
            String natureId;
            if (ce[i].getName().equals(NATURE) && (natureId = ce[i].getAttribute(STATIC_ID)) != null) {
                this.registerNatureID(natureId);
            }
            ++i;
        }
    }

    private void registerNatureID(String natureId) {
        if (!this.REGISTERED_NATURE_IDS.contains(natureId)) {
            this.REGISTERED_NATURE_IDS.add(natureId);
        } else {
            Logger.getLogger().logError(EMFWorkbenchResourceHandler.getString("EMFNatureRegistry_ERROR_0", new Object[]{natureId}));
        }
    }
}

